function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/server/level/ServerLevel',
		'methodName' : resolveName('m_6559_'), // onBlockStateChange
		'methodDesc' : '(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/forge/events/BlockStateChangeEvent',
		'methodName' : 'onBlockStateChange',
		'methodDesc' : '(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V'
	}

	var instructions = [ 
		insnLoadObj(0, "level"),
		insnLoadObj(1, "pos"),
		insnLoadObj(2, "oldState"),
		insnLoadObj(3, "newState"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}