function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/level/block/state/BlockBehaviour$BlockStateBase',
		'methodName' : resolveName('m_222972_'), // randomTick
		'methodDesc' : '(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/forge/events/RandomTickEvent',
		'methodName' : 'onRandomTickBlock',
		'methodDesc' : '(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z'
	}

	var asState = {
		'class' : 'net/minecraft/world/level/block/state/BlockBehaviour$BlockStateBase',
		'methodName' : resolveName('m_7160_'), // asState
		'methodDesc' : '()Lnet/minecraft/world/level/block/state/BlockState;'
	}

    var instructions = [
        insnLoadObj(1, "level"),
        insnLoadObj(2, "pos"),
		insnLoadObj(0, "state"),
		insnInvokeVirtual(asState),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions.concat(instructionsIfTrueReturn()));
				return method;
			}
		}
	}
}