function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'moze_intel/projecte/gameObjs/block_entities/DMFurnaceBlockEntity',
		'methodName' : 'tickServer',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lmoze_intel/projecte/gameObjs/block_entities/DMFurnaceBlockEntity;)V'
	}

	var node = {
		'class' : 'net/minecraft/world/item/ItemStack',
		'methodName' : resolveName('m_41774_'), // shrink 
		'methodDesc' : '(I)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFurnaceFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
		insnPushValue(1, "fuel amount"),
		insnLoadObj(3, "furnace tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, [].concat(instructionsDupValue2("fuel stack"), instructions));
				return method;
			}
		}
	}
}