function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/blakebr0/mysticalagriculture/tileentity/EssenceFurnaceTileEntity',
		'methodName' : 'tick',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/blakebr0/mysticalagriculture/tileentity/EssenceFurnaceTileEntity;)V'
	}

    var node = {
		'class' : 'net/minecraft/world/item/ItemStack',
		'methodName' : 'hasContainerItem',
		'methodDesc' : '()Z'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFurnaceFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
	    insnDup("fuel"),
		insnPushValue(1, "fuel amount"),
		insnLoadObj(3, "tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}