/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.handler;

import com.github.eterdelta.crittersandcompanions.capability.CACCapabilities;
import com.github.eterdelta.crittersandcompanions.capability.ISilkLeashStateCapability;
import com.github.eterdelta.crittersandcompanions.entity.DumboOctopusEntity;
import com.github.eterdelta.crittersandcompanions.entity.ILeashStateEntity;
import com.github.eterdelta.crittersandcompanions.entity.KoiFishEntity;
import com.github.eterdelta.crittersandcompanions.item.SilkLeashItem;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundBubbleStatePacket;
import com.github.eterdelta.crittersandcompanions.network.ClientboundGrapplingStatePacket;
import com.github.eterdelta.crittersandcompanions.network.ClientboundSilkLeashStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="crittersandcompanions")
public class PlayerHandler {
    public static InteractionHand getOppositeHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    @SubscribeEvent
    public static void onPlayerEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (event.getSide().isServer() && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            Player player = event.getEntity();
            ItemStack handStack = player.m_21120_(event.getHand());
            ItemStack otherHandStack = player.m_21120_(PlayerHandler.getOppositeHand(event.getHand()));
            LazyOptional playerLeashCap = player.getCapability(CACCapabilities.SILK_LEASH_STATE);
            playerLeashCap.ifPresent(playerLeashState -> {
                Set<LivingEntity> playerLeashingEntities = playerLeashState.getLeashingEntities();
                if (!otherHandStack.m_150930_((Item)CACItems.SILK_LEAD.get())) {
                    if ((playerLeashingEntities.isEmpty() || playerLeashingEntities.contains(entity2)) && !handStack.m_150930_((Item)CACItems.SILK_LEAD.get()) && !handStack.m_150930_(Items.f_42655_) && event.getHand() == InteractionHand.MAIN_HAND) {
                        int unleashedStates = 0;
                        unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(entity2, null) - 1);
                        if ((unleashedStates += Math.max(0, SilkLeashItem.updateLeashStates(null, entity2) - 1)) > 0) {
                            ItemEntity leadEntity = new ItemEntity(event.getLevel(), entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_(), new ItemStack((ItemLike)CACItems.SILK_LEAD.get(), unleashedStates));
                            event.getLevel().m_7967_((Entity)leadEntity);
                            event.setCanceled(true);
                            event.setCancellationResult(InteractionResult.SUCCESS);
                        }
                    } else {
                        LivingEntity uniqueLeash = (LivingEntity)Iterables.getFirst(playerLeashingEntities, null);
                        if (uniqueLeash != null && SilkLeashItem.updateLeashStates(uniqueLeash, entity2) != 0) {
                            SilkLeashItem.updateLeashStates((LivingEntity)player, null);
                            event.setCanceled(true);
                            event.setCancellationResult(InteractionResult.SUCCESS);
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        List nearKoiFishes;
        if (event.phase == TickEvent.Phase.END && event.side.isServer() && (nearKoiFishes = event.player.m_9236_().m_6443_(KoiFishEntity.class, event.player.m_20191_().m_82400_(10.0), EntitySelector.f_20402_)).size() >= 3) {
            event.player.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 210, 0, false, false));
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        LazyOptional<ISilkLeashStateCapability> silkLeashCap;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity trackedEntity = (LivingEntity)entity;
            silkLeashCap = ((ILeashStateEntity)trackedEntity).getLeashStateCache();
            silkLeashCap.ifPresent(trackedState -> CACPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new ClientboundSilkLeashStatePacket(new ClientboundSilkLeashStatePacket.LeashData(trackedEntity.m_19879_(), (IntList)new IntArrayList(trackedState.getLeashingEntities().stream().mapToInt(Entity::m_19879_).toArray()), (IntList)new IntArrayList(trackedState.getLeashedByEntities().stream().mapToInt(Entity::m_19879_).toArray())))));
        }
        if ((silkLeashCap = event.getTarget()) instanceof Player) {
            Player trackedPlayer = (Player)silkLeashCap;
            LazyOptional bubbleCap = trackedPlayer.getCapability(CACCapabilities.BUBBLE_STATE);
            bubbleCap.ifPresent(trackedState -> CACPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new ClientboundBubbleStatePacket(trackedState.isActive(), trackedPlayer.m_19879_())));
            LazyOptional grappleCap = trackedPlayer.getCapability(CACCapabilities.GRAPPLING_STATE);
            grappleCap.ifPresent(trackedState -> CACPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new ClientboundGrapplingStatePacket(trackedState.getHook() != null ? Optional.of(trackedState.getHook().m_19879_()) : Optional.empty(), trackedPlayer.m_19879_())));
        }
    }

    @SubscribeEvent
    public static void onPlayerStopTracking(PlayerEvent.StopTracking event) {
        DumboOctopusEntity dumboOctopus;
        Entity entity = event.getTarget();
        if (entity instanceof DumboOctopusEntity && (dumboOctopus = (DumboOctopusEntity)entity).getBubbledPlayer() == event.getEntity()) {
            dumboOctopus.sendBubble((ServerPlayer)event.getEntity(), false);
        }
    }
}

