/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.renderer;

import com.github.eterdelta.crittersandcompanions.client.model.GrapplingHookModel;
import com.github.eterdelta.crittersandcompanions.entity.GrapplingHookEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GrapplingHookRenderer
extends EntityRenderer<GrapplingHookEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("crittersandcompanions", "grappling_hook"), "main");
    private static final ResourceLocation TEXTURE = new ResourceLocation("crittersandcompanions", "textures/entity/grappling_hook.png");
    private final GrapplingHookModel<GrapplingHookEntity> hookModel;

    public GrapplingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.hookModel = new GrapplingHookModel(context.m_174023_(LAYER_LOCATION));
    }

    private static void stringVertex(float p_174119_, float p_174120_, float p_174121_, VertexConsumer vertexConsumer, PoseStack.Pose pose, float p_174124_, float p_174125_) {
        float f = p_174119_ * p_174124_;
        float f1 = p_174120_ * (p_174124_ * p_174124_ + p_174124_) * 0.5f + 0.25f;
        float f2 = p_174121_ * p_174124_;
        float f3 = p_174119_ * p_174125_ - f;
        float f4 = p_174120_ * (p_174125_ * p_174125_ + p_174125_) * 0.5f + 0.25f - f1;
        float f5 = p_174121_ * p_174125_ - f2;
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        vertexConsumer.m_85982_(pose.m_85861_(), f, f1, f2).m_6122_(193, 184, 205, 255).m_85977_(pose.m_85864_(), f3 /= f6, f4 /= f6, f5 /= f6).m_5752_();
    }

    public void render(GrapplingHookEntity entity, float p_114706_, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Player player = (Player)entity.m_37282_();
        if (player != null && entity.isFocused()) {
            float f3;
            double d6;
            double d5;
            double d4;
            int handOffset;
            poseStack.m_85836_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -1.25, 0.0);
            VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
            this.hookModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            int n = handOffset = player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
            if (!player.m_21205_().m_150930_(entity.getOwnerStack().m_41720_())) {
                handOffset = -handOffset;
            }
            float f = player.m_21324_(partialTicks);
            float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
            float f2 = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
            double d0 = Mth.m_14031_((float)f2);
            double d1 = Mth.m_14089_((float)f2);
            double d2 = (double)handOffset * 0.35;
            if (this.f_114476_.f_114360_.m_92176_().m_90612_() && player == Minecraft.m_91087_().f_91074_) {
                double d7 = 960.0 / (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue();
                Vec3 vec3 = this.f_114476_.f_114358_.m_167684_().m_167695_((float)handOffset * 0.825f, -0.08f);
                vec3 = vec3.m_82490_(d7);
                vec3 = vec3.m_82524_(f1 * 0.5f);
                vec3 = vec3.m_82496_(-f1 * 0.7f);
                d4 = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + vec3.f_82479_;
                d5 = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + vec3.f_82480_;
                d6 = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + vec3.f_82481_;
                f3 = player.m_20192_();
            } else {
                d4 = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - d1 * d2 - d0 * 0.8;
                d5 = player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 0.45;
                d6 = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - d0 * d2 + d1 * 0.8;
                f3 = player.m_6047_() ? -0.1875f : 0.0f;
            }
            double hookPosX = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
            double hookPosY = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_()) + 0.4;
            double hookPosZ = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
            float f4 = (float)(d4 - hookPosX);
            float f5 = (float)(d5 - hookPosY) + f3;
            float f6 = (float)(d6 - hookPosZ);
            VertexConsumer stringVertexConsumer = bufferSource.m_6299_(RenderType.m_173247_());
            PoseStack.Pose pose = poseStack.m_85850_();
            GrapplingHookRenderer.stringVertex(f4, f5, f6, stringVertexConsumer, pose, 0.0f, 1.0f);
            GrapplingHookRenderer.stringVertex(f4, f5, f6, stringVertexConsumer, pose, 1.0f, 2.0f);
            poseStack.m_85849_();
            super.m_7392_((Entity)entity, p_114706_, partialTicks, poseStack, bufferSource, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(GrapplingHookEntity entity) {
        return TEXTURE;
    }
}

