/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BiomeSubRegistryHelper
extends AbstractSubRegistryHelper<Biome> {
    public BiomeSubRegistryHelper(RegistryHelper parent, DeferredRegister<Biome> deferredRegister) {
        super(parent, deferredRegister);
    }

    public BiomeSubRegistryHelper(RegistryHelper parent) {
        super(parent, DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)parent.modId));
    }

    public KeyedBiome createBiome(String name, Supplier<Biome> biome) {
        return new KeyedBiome((RegistryObject<Biome>)this.deferredRegister.register(name, biome));
    }

    public static final class KeyedBiome {
        private static final ForgeRegistry<Biome> BIOME_REGISTRY = (ForgeRegistry)ForgeRegistries.BIOMES;
        private final RegistryObject<Biome> biome;
        private final LazyLoadedValue<ResourceKey<Biome>> lazyKey;

        public KeyedBiome(RegistryObject<Biome> biome) {
            this.biome = biome;
            this.lazyKey = new LazyLoadedValue(() -> BIOME_REGISTRY.getKey(BIOME_REGISTRY.getID((Object)((Biome)this.biome.get()))));
        }

        public Biome get() {
            return (Biome)this.biome.get();
        }

        public RegistryObject<Biome> getObject() {
            return this.biome;
        }

        public ResourceKey<Biome> getKey() {
            return (ResourceKey)this.lazyKey.m_13971_();
        }
    }
}

