/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.network.entity;

import com.teamabnormals.blueprint.client.ClientInfo;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public final class MessageS2CTeleportEntity {
    private int entityId;
    private double posX;
    private double posY;
    private double posZ;

    public MessageS2CTeleportEntity(int entityID, double posX, double posY, double posZ) {
        this.entityId = entityID;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static MessageS2CTeleportEntity deserialize(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        return new MessageS2CTeleportEntity(entityId, buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(MessageS2CTeleportEntity message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        Entity entity = ClientInfo.getClientPlayerLevel().m_6815_(message.entityId);
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                if (entity != null) {
                    entity.m_7678_(message.posX, message.posY, message.posZ, entity.m_146908_(), entity.m_146909_());
                }
            });
            context.setPacketHandled(true);
        }
    }
}

