/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.entity;

import com.teamabnormals.blueprint.client.renderer.IBlueprintBoat;
import com.teamabnormals.blueprint.core.registry.BlueprintEntityTypes;
import com.teamabnormals.blueprint.core.registry.BoatTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BlueprintBoat
extends Boat
implements IBlueprintBoat {
    private static final EntityDataAccessor<String> BOAT_TYPE = SynchedEntityData.m_135353_(BlueprintBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public BlueprintBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
    }

    public BlueprintBoat(Level level, String type, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)BlueprintEntityTypes.BOAT.get()), level);
        this.setType(type);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public BlueprintBoat(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends Boat>)((EntityType)BlueprintEntityTypes.BOAT.get()), level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOAT_TYPE, (Object)"minecraft:oak");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("Type", BoatTypeRegistry.getNameForData(this.getBoatTypeData()));
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("Type", 8)) {
            String type = compound.m_128461_("Type");
            BoatTypeRegistry.BoatTypeData data = BoatTypeRegistry.getTypeData(type);
            if (data != null) {
                this.setType(BoatTypeRegistry.getNameForData(data));
            } else {
                this.setType(BoatTypeRegistry.getBaseBoatName());
            }
        } else {
            this.setType(BoatTypeRegistry.getBaseBoatName());
        }
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGroundIn) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.f_19789_ = 0.0f;
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && this.m_6084_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getBoatTypeData().getPlankItem());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.f_19789_ = 0.0f;
            } else if (!this.f_19853_.m_6425_(new BlockPos(this.m_20182_()).m_7495_()).m_205070_(FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ = (float)((double)this.f_19789_ - y);
            }
        }
    }

    public Item m_38369_() {
        return this.getBoatTypeData().getBoatItem();
    }

    public Boat.Type m_38387_() {
        return Boat.Type.OAK;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setType(String type) {
        this.f_19804_.m_135381_(BOAT_TYPE, (Object)type);
    }

    public BoatTypeRegistry.BoatTypeData getBoatTypeData() {
        return BoatTypeRegistry.getTypeData((String)this.f_19804_.m_135370_(BOAT_TYPE));
    }

    @Override
    public ResourceLocation getTexture() {
        return this.getBoatTypeData().getTexture();
    }
}

