/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_furniture.common.block.AbstractCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.ClosedCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ClosedCurtainPart;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.common.block.properties.OpenCurtainPart;

public class OpenCurtainBlock
extends AbstractCurtainBlock<OpenCurtainPart> {
    public static EnumProperty<OpenCurtainPart> PART = ModBlockStateProperties.OPEN_CURTAIN_PART;

    public OpenCurtainBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(PART, (Comparable)((Object)OpenCurtainPart.SINGLE))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        OpenCurtainPart part = (OpenCurtainPart)((Object)state.m_61143_(PART));
        if (part == OpenCurtainPart.MIDDLE) {
            return Shapes.m_83040_();
        }
        if (part == OpenCurtainPart.TOP) {
            return (VoxelShape)BRACKET_SHAPES.get(facing);
        }
        return part.isTopOrSingle() ? (VoxelShape)TOP_SHAPES.get(facing) : (VoxelShape)SHAPES.get(facing);
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return ((OpenCurtainPart)((Object)state.m_61143_(PART))).isTopOrSingle() ? (VoxelShape)BRACKET_SHAPES.get(state.m_61143_((Property)FACING)) : Shapes.m_83040_();
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return state.m_61143_(PART) == OpenCurtainPart.MIDDLE ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.getClosedBlock());
    }

    @Override
    protected void updateOpen(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos) {
        Direction base = (Direction)state.m_61143_((Property)FACING);
        Direction left = base.m_122427_();
        Direction right = base.m_122428_();
        BlockPos topPos = this.getTopBlock((LevelAccessor)level, pos);
        int length = this.getCurtainLength((LevelAccessor)level, topPos);
        boolean leftConnected = this.isConnected((LevelAccessor)level, state, topPos, left, length);
        boolean rightConnected = this.isConnected((LevelAccessor)level, state, topPos, right, length);
        this.openRow(level, topPos, length, leftConnected, rightConnected);
        if (leftConnected) {
            this.openRows(level, state, topPos.m_122032_(), left, base, length);
        }
        if (rightConnected) {
            this.openRows(level, state, topPos.m_122032_(), right, base, length);
        }
    }

    @Override
    protected OpenCurtainPart getPart(BlockState state) {
        return (OpenCurtainPart)((Object)state.m_61143_(PART));
    }

    @Override
    protected void openRow(Level level, BlockPos topPos, int length, boolean leftConnected, boolean rightConnected) {
        ClosedCurtainBlock block = this.getClosedBlock();
        for (int i = 0; i < length; ++i) {
            BlockState state = level.m_8055_(topPos.m_6625_(i));
            OpenCurtainPart part = (OpenCurtainPart)((Object)state.m_61143_(PART));
            ClosedCurtainPart newPart = ClosedCurtainPart.SINGLE;
            if (length != 1) {
                if (part.isTopOrSingle()) {
                    newPart = ClosedCurtainPart.TOP;
                } else if (part.isMiddle()) {
                    newPart = i + 1 >= length ? ClosedCurtainPart.BOTTOM : ClosedCurtainPart.MIDDLE;
                } else if (part.isBottomOrSingle()) {
                    newPart = ClosedCurtainPart.BOTTOM;
                }
            }
            level.m_46597_(topPos.m_6625_(i), (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_(ClosedCurtainBlock.PART, (Comparable)((Object)newPart))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)POWERED, (Comparable)((Boolean)state.m_61143_((Property)POWERED))));
        }
    }

    @Override
    protected boolean isOpen() {
        return true;
    }

    @Override
    protected OpenCurtainPart connect(BlockState aState, BlockState bState, Direction facing) {
        return OpenCurtainPart.getTypeForConnections(aState.m_60734_() instanceof OpenCurtainBlock && aState.m_61143_((Property)FACING) == facing, bState.m_60734_() instanceof OpenCurtainBlock && bState.m_61143_((Property)FACING) == facing);
    }

    private void updateAboveAndBelow(Level level, BlockState state, BlockPos above, BlockPos below, Direction facing) {
        BlockState aboveState = level.m_8055_(above);
        BlockState belowState = level.m_8055_(below);
        if (aboveState.m_60713_((Block)this)) {
            level.m_46597_(above, (BlockState)aboveState.m_61124_(PART, (Comparable)((Object)this.connect(level.m_8055_(above.m_7494_()), state, facing))));
        }
        if (belowState.m_60713_((Block)this)) {
            level.m_46597_(below, (BlockState)belowState.m_61124_(PART, (Comparable)((Object)this.connect(state, level.m_8055_(below.m_7495_()), facing))));
        }
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!(newState.m_60734_() instanceof AbstractCurtainBlock) && state.m_61143_(PART) != OpenCurtainPart.SINGLE) {
            level.m_46597_(pos, state);
            this.updateOpen(state, level, pos);
            level.m_7471_(pos, false);
        }
        if (!(newState.m_60734_() instanceof AbstractCurtainBlock)) {
            this.updateAboveAndBelow(level, newState, pos.m_7494_(), pos.m_7495_(), (Direction)state.m_61143_((Property)FACING));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, POWERED, FACING});
    }
}

