/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.common.util.TextureKey;

public class DeskBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final String TEXTURE_PATH = "block/desk/";
    public static final Map<String, List<TextureKey>> VARIANT_TEXTURES = ImmutableMap.builder().put((Object)"single", List.of(TextureKey.of("top", "block/desk/"), TextureKey.of("top_middle", "block/desk/"), TextureKey.of("front", "block/desk/"), TextureKey.of("side", "block/desk/"))).put((Object)"center", List.of(TextureKey.of("top_side", "block/desk/"), TextureKey.of("top_middle", "block/desk/"), TextureKey.of("front", "block/desk/"), TextureKey.of("side", "block/desk/"), TextureKey.of("middle", "block/desk/"))).put((Object)"left_or_right", List.of(TextureKey.of("top", "block/desk/"), TextureKey.of("top_side", "block/desk/"), TextureKey.of("top_middle", "block/desk/"), TextureKey.of("front", "block/desk/"), TextureKey.of("side", "block/desk/"), TextureKey.of("middle", "block/desk/"))).build();
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LEFT = ModBlockStateProperties.LEFT;
    public static final BooleanProperty RIGHT = ModBlockStateProperties.RIGHT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<BlockState, VoxelShape> shapesCache;
    private static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> TWO_LEGS_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Shapes.m_83124_((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0)}));
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0)});
    private static final Map<Direction, VoxelShape> CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)4.0));
    private static final Map<Direction, VoxelShape> FULL_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0));
    private static final Map<Direction, VoxelShape> LEFT_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)4.0));
    private static final Map<Direction, VoxelShape> RIGHT_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0));
    private final TagKey<Block> tag;

    public DeskBlock(TagKey<Block> tag, BlockBehaviour.Properties properties) {
        super(properties);
        this.tag = tag;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.m_152458_(this::calculateShape);
    }

    private VoxelShape calculateShape(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean left = (Boolean)state.m_61143_((Property)LEFT);
        boolean right = (Boolean)state.m_61143_((Property)RIGHT);
        if (left && right) {
            return Shapes.m_83110_((VoxelShape)TOP_SHAPE, (VoxelShape)FULL_CONNECT_SHAPES.get(facing.m_122424_()));
        }
        if (left) {
            return Shapes.m_83124_((VoxelShape)TWO_LEGS_SHAPES.get(facing.m_122427_()), (VoxelShape[])new VoxelShape[]{LEFT_CONNECT_SHAPES.get(facing.m_122424_()), CONNECT_SHAPES.get(facing.m_122427_().m_122424_())});
        }
        if (right) {
            return Shapes.m_83124_((VoxelShape)TWO_LEGS_SHAPES.get(facing.m_122427_().m_122424_()), (VoxelShape[])new VoxelShape[]{RIGHT_CONNECT_SHAPES.get(facing.m_122424_()), CONNECT_SHAPES.get(facing.m_122427_())});
        }
        return Shapes.m_83124_((VoxelShape)SHAPE, (VoxelShape[])new VoxelShape[]{CONNECT_SHAPES.get(facing.m_122424_()), CONNECT_SHAPES.get(facing.m_122427_().m_122424_()), CONNECT_SHAPES.get(facing.m_122427_())});
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shapesCache.get(state);
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        boolean right;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_8125_().m_122424_();
        boolean flag = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        BlockState leftState = level.m_8055_(pos.m_121945_(facing.m_122427_()));
        BlockState secondLefState = level.m_8055_(pos.m_5484_(facing.m_122427_(), 2));
        BlockState rightState = level.m_8055_(pos.m_121945_(facing.m_122428_()));
        BlockState secondRightState = level.m_8055_(pos.m_5484_(facing.m_122428_(), 2));
        boolean left = this.hasSameFacing(leftState, facing) && (!secondLefState.m_204336_(this.tag) || secondLefState.m_61143_((Property)FACING) != facing || !this.isCenterPart(secondLefState));
        boolean bl = right = this.hasSameFacing(rightState, facing) && (!secondRightState.m_204336_(this.tag) || secondRightState.m_61143_((Property)FACING) != facing || !this.isCenterPart(secondRightState));
        if (left && right) {
            if (this.hasSameFacing(secondRightState, facing) && ((Boolean)secondRightState.m_61143_((Property)LEFT)).booleanValue()) {
                right = false;
            } else if (this.hasSameFacing(secondLefState, facing) && ((Boolean)secondLefState.m_61143_((Property)RIGHT)).booleanValue()) {
                left = false;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(right))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean isCenterPart(BlockState state) {
        return state.m_204336_(this.tag) && (Boolean)state.m_61143_((Property)LEFT) != false && (Boolean)state.m_61143_((Property)RIGHT) != false;
    }

    public boolean hasSameFacing(BlockState state, Direction facing) {
        return state.m_204336_(this.tag) && state.m_61143_((Property)FACING) == facing;
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean flag = this.hasSameFacing(neighborState, facing);
        if (direction == facing.m_122427_()) {
            return (BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(flag && (Boolean)neighborState.m_61143_((Property)RIGHT) != false));
        }
        if (direction == facing.m_122428_()) {
            return (BlockState)state.m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(flag && (Boolean)neighborState.m_61143_((Property)LEFT) != false));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LEFT, RIGHT, WATERLOGGED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }
}

