/*
 * Decompiled with CFR 0.152.
 */
package net.lordkipama.modernminecarts.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.lordkipama.modernminecarts.entity.CustomAbstractMinecartEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CustomMinecartRenderer<T extends CustomAbstractMinecartEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation MINECART_LOCATION = new ResourceLocation("textures/entity/minecart.png");
    private static final ResourceLocation CHAIN_LOCATION = new ResourceLocation("modernminecarts", "textures/entity/chain.png");
    private static final RenderType CHAIN_TYPE = RenderType.m_110458_((ResourceLocation)CHAIN_LOCATION);
    protected final EntityModel<T> model;
    private final BlockRenderDispatcher blockRenderer;

    public CustomMinecartRenderer(EntityRendererProvider.Context pContext, ModelLayerLocation pLayer) {
        super(pContext);
        this.f_114477_ = 0.7f;
        this.model = new MinecartModel(pContext.m_174023_(pLayer));
        this.blockRenderer = pContext.m_234597_();
    }

    public void render(@NotNull T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85836_();
        long i = (long)pEntity.m_19879_() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        pMatrixStack.m_85837_((double)f, (double)f1, (double)f2);
        double d0 = Mth.m_14139_((double)pPartialTicks, (double)((CustomAbstractMinecartEntity)pEntity).f_19790_, (double)pEntity.m_20185_());
        double d1 = Mth.m_14139_((double)pPartialTicks, (double)((CustomAbstractMinecartEntity)pEntity).f_19791_, (double)pEntity.m_20186_());
        double d2 = Mth.m_14139_((double)pPartialTicks, (double)((CustomAbstractMinecartEntity)pEntity).f_19792_, (double)pEntity.m_20189_());
        double d3 = 0.3f;
        Vec3 vec3 = pEntity.m_38179_(d0, d1, d2);
        float f3 = Mth.m_14179_((float)pPartialTicks, (float)((CustomAbstractMinecartEntity)pEntity).f_19860_, (float)pEntity.m_146909_());
        if (vec3 != null) {
            Vec3 vec31 = pEntity.m_38096_(d0, d1, d2, (double)0.3f);
            Vec3 vec32 = pEntity.m_38096_(d0, d1, d2, (double)-0.3f);
            if (vec31 == null) {
                vec31 = vec3;
            }
            if (vec32 == null) {
                vec32 = vec3;
            }
            pMatrixStack.m_85837_(vec3.f_82479_ - d0, (vec31.f_82480_ + vec32.f_82480_) / 2.0 - d1, vec3.f_82481_ - d2);
            Vec3 vec33 = vec32.m_82520_(-vec31.f_82479_, -vec31.f_82480_, -vec31.f_82481_);
            if (vec33.m_82553_() != 0.0) {
                vec33 = vec33.m_82541_();
                pEntityYaw = (float)(Math.atan2(vec33.f_82481_, vec33.f_82479_) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(vec33.f_82480_) * 73.0);
            }
        }
        pMatrixStack.m_85837_(0.0, 0.375, 0.0);
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - pEntityYaw));
        pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-f3));
        float f5 = (float)pEntity.m_38176_() - pPartialTicks;
        float f6 = pEntity.m_38169_() - pPartialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            pMatrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f5) * f5 * f6 / 10.0f * (float)pEntity.m_38177_()));
        }
        int j = pEntity.m_38183_();
        BlockState blockstate = pEntity.m_38178_();
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            pMatrixStack.m_85836_();
            float f4 = 0.75f;
            pMatrixStack.m_85841_(0.75f, 0.75f, 0.75f);
            pMatrixStack.m_85837_(-0.5, (double)((float)(j - 8) / 16.0f), 0.5);
            pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            this.renderMinecartContents(pEntity, pPartialTicks, blockstate, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.m_85849_();
        }
        pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.m_6973_(pEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(this.model.m_103119_(this.getTextureLocation(pEntity)));
        this.model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pMatrixStack.m_85849_();
        CustomAbstractMinecartEntity parent = ((CustomAbstractMinecartEntity)pEntity).getLinkedParent();
        if (parent != null) {
            double startX = parent.m_20185_();
            double startY = parent.m_20186_();
            double startZ = parent.m_20189_();
            double endX = pEntity.m_20185_();
            double endY = pEntity.m_20186_();
            double endZ = pEntity.m_20189_();
            float distanceX = (float)(startX - endX);
            float distanceY = (float)(startY - endY);
            float distanceZ = (float)(startZ - endZ);
            float distance = pEntity.m_20270_((Entity)parent);
            double hAngle = Math.toDegrees(Math.atan2(endZ - startZ, endX - startX));
            hAngle += Math.ceil(-hAngle / 360.0) * 360.0;
            double vAngle = Math.asin(distanceY / distance);
            this.renderChain(distanceX, distanceY, distanceZ, (float)hAngle, (float)vAngle, pMatrixStack, pBuffer, pPackedLight);
        }
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return MINECART_LOCATION;
    }

    protected void renderMinecartContents(T pEntity, float pPartialTicks, BlockState pState, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        this.blockRenderer.m_110912_(pState, pMatrixStack, pBuffer, pPackedLight, OverlayTexture.f_118083_);
    }

    public void renderChain(float x, float y, float z, float hAngle, float vAngle, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        float squaredLength = x * x + y * y + z * z;
        float length = (float)Math.sqrt(squaredLength) - 1.0f;
        pMatrixStack.m_85836_();
        pMatrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-hAngle - 90.0f));
        pMatrixStack.m_85845_(Vector3f.f_122223_.m_122270_(-vAngle));
        pMatrixStack.m_85837_(0.0, 0.0, 0.5);
        pMatrixStack.m_85836_();
        VertexConsumer vertexConsumer = pBuffer.m_6299_(CHAIN_TYPE);
        float vertX1 = 0.0f;
        float vertY1 = 0.25f;
        float vertX2 = (float)Math.sin(6.2831854820251465) * 0.125f;
        float vertY2 = (float)Math.cos(6.2831854820251465) * 0.125f;
        float minU = 0.0f;
        float maxU = 0.1875f;
        float minV = 0.0f;
        float maxV = length / 10.0f;
        PoseStack.Pose entry = pMatrixStack.m_85850_();
        Matrix4f matrix4f = entry.m_85861_();
        Matrix3f matrix3f = entry.m_85864_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        pMatrixStack.m_85849_();
        pMatrixStack.m_85837_(0.19, 0.19, 0.0);
        pMatrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
        entry = pMatrixStack.m_85850_();
        matrix4f = entry.m_85861_();
        matrix3f = entry.m_85864_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX1, vertY1, length).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, length).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_85982_(matrix4f, vertX2, vertY2, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        pMatrixStack.m_85849_();
    }
}

