/*
 * Decompiled with CFR 0.152.
 */
package net.lordkipama.modernminecarts.block.Custom;

import net.lordkipama.modernminecarts.ModernMinecartsConfig;
import net.lordkipama.modernminecarts.block.ModBlocks;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class WaxedCopperRailBlock
extends PoweredRailBlock {
    private final WaxedWeatherState waxedWeatherState;

    public WaxedCopperRailBlock(BlockBehaviour.Properties copy, WaxedWeatherState waxedWeatherState) {
        super(copy, true);
        this.waxedWeatherState = waxedWeatherState;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        String version = String.valueOf((Object)this.waxedWeatherState);
        float finalSpeed = 0.4f;
        if (version == "WAXED_UNAFFECTED") {
            finalSpeed = ModernMinecartsConfig.copper_speed;
        } else if (version == "WAXED_EXPOSED") {
            finalSpeed = ModernMinecartsConfig.exposed_copper_speed;
        } else if (version == "WAXED_WEATHERED") {
            finalSpeed = ModernMinecartsConfig.weathered_copper_speed;
        } else if (version == "WAXED_OXIDIZED") {
            finalSpeed = ModernMinecartsConfig.oxidized_copper_speed;
        }
        if (this.getRailDirection(state, (BlockGetter)level, pos, null).m_61745_() && finalSpeed >= ModernMinecartsConfig.max_ascending_speed) {
            return ModernMinecartsConfig.max_ascending_speed;
        }
        return finalSpeed;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (!player.m_7500_() && !player.m_5833_()) {
            player.m_21120_(interactionHand).m_41721_(player.m_21120_(interactionHand).m_41773_() + 1);
        }
        if (!level.m_5776_()) {
            if (this.waxedWeatherState == WaxedWeatherState.WAXED_UNAFFECTED) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, pos, itemstack);
                }
                level.m_7731_(pos, ((Block)ModBlocks.COPPER_RAIL.get()).m_152465_(state), 1);
            } else if (this.waxedWeatherState == WaxedWeatherState.WAXED_EXPOSED) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, pos, itemstack);
                }
                level.m_7731_(pos, ((Block)ModBlocks.EXPOSED_COPPER_RAIL.get()).m_152465_(state), 1);
            } else if (this.waxedWeatherState == WaxedWeatherState.WAXED_WEATHERED) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, pos, itemstack);
                }
                level.m_7731_(pos, ((Block)ModBlocks.WEATHERED_COPPER_RAIL.get()).m_152465_(state), 1);
            } else if (this.waxedWeatherState == WaxedWeatherState.WAXED_OXIDIZED) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, pos, itemstack);
                }
                level.m_7731_(pos, ((Block)ModBlocks.OXIDIZED_COPPER_RAIL.get()).m_152465_(state), 1);
            }
        }
        player.m_6674_(interactionHand);
        level.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_5898_(player, 3004, pos, 0);
        return super.m_6227_(state, level, pos, player, interactionHand, blockHitResult);
    }

    public static enum WaxedWeatherState {
        WAXED_UNAFFECTED,
        WAXED_EXPOSED,
        WAXED_WEATHERED,
        WAXED_OXIDIZED;

    }
}

