/*
 * Decompiled with CFR 0.152.
 */
package net.lordkipama.modernminecarts.block.Custom;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.lordkipama.modernminecarts.Item.AbstractMinecartItem;
import net.lordkipama.modernminecarts.block.ModBlocks;
import net.lordkipama.modernminecarts.entity.CustomAbstractMinecartContainerEntity;
import net.lordkipama.modernminecarts.entity.CustomAbstractMinecartEntity;
import net.lordkipama.modernminecarts.entity.CustomMinecartCommandBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RailState;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class PoweredDetectorRailBlock
extends BaseRailBlock {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WEIGHT_INVERTED = BooleanProperty.m_61465_((String)"weight_inverted");
    public static final BooleanProperty INVERTED = BlockStateProperties.f_61441_;

    public PoweredDetectorRailBlock(BlockBehaviour.Properties p_55218_) {
        super(true, p_55218_);
        this.registerDefaultState();
    }

    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    public boolean getDirInverted(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)INVERTED);
    }

    public boolean getWeightInverted(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WEIGHT_INVERTED);
    }

    public RailShape getRailShape(BlockState pState) {
        return (RailShape)pState.m_61143_(SHAPE);
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    protected void registerDefaultState() {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_((Property)f_152149_, (Comparable)Boolean.FALSE)).m_61124_((Property)WEIGHT_INVERTED, (Comparable)Boolean.FALSE)).m_61124_((Property)INVERTED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_55408_) {
        p_55408_.m_61104_(new Property[]{SHAPE, f_152149_, POWERED, WEIGHT_INVERTED, INVERTED});
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pLevel.f_46443_ && !((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            this.checkPressed(pLevel, pPos, pState);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (itemstack.m_41720_() instanceof AbstractMinecartItem || itemstack.m_150930_(Items.f_42155_) || itemstack.m_150930_(Items.f_42009_) || itemstack.m_150930_(Items.f_42768_)) {
            return super.m_6227_(state, level, pos, player, interactionHand, blockHitResult);
        }
        if (player.m_6047_()) {
            state = (BlockState)state.m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)INVERTED) == false));
            level.m_7731_(pos, ((Block)ModBlocks.POWERED_DETECTOR_RAIL.get()).m_152465_(state), 1);
            level.m_5594_(player, pos, SoundEvents.f_12015_, SoundSource.BLOCKS, 0.3f, 0.6f);
        } else {
            state = (BlockState)state.m_61124_((Property)WEIGHT_INVERTED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)WEIGHT_INVERTED) == false));
            state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)((Boolean)state.m_61143_((Property)WEIGHT_INVERTED)));
            level.m_7731_(pos, ((Block)ModBlocks.POWERED_DETECTOR_RAIL.get()).m_152465_(state), 1);
            level.m_5594_(player, pos, SoundEvents.f_11762_, SoundSource.BLOCKS, 0.3f, (Boolean)state.m_61143_((Property)WEIGHT_INVERTED) != false ? 0.55f : 0.5f);
        }
        return InteractionResult.SUCCESS;
    }

    protected BlockState m_49389_(BlockState pState, Level pLevel, BlockPos pPos, boolean pMovedByPiston) {
        pState = this.m_49367_(pLevel, pPos, pState, true);
        pLevel.m_213960_(pState, pPos, (Block)this, pPos, pMovedByPiston);
        return pState;
    }

    private void checkPressed(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.m_7898_(pState, (LevelReader)pLevel, pPos)) {
            boolean isPowered = (Boolean)pState.m_61143_((Property)POWERED);
            boolean isInverted = (Boolean)pState.m_61143_((Property)WEIGHT_INVERTED);
            List<CustomAbstractMinecartEntity> mclist = this.getInteractingMinecartOfType(pLevel, pPos, CustomAbstractMinecartEntity.class, p_153125_ -> true);
            List<CustomAbstractMinecartContainerEntity> container_list = this.getInteractingMinecartOfType(pLevel, pPos, CustomAbstractMinecartContainerEntity.class, p_153125_ -> true);
            boolean isContainer = !container_list.isEmpty();
            boolean minecartFull = mclist.stream().anyMatch(Entity::m_20160_);
            if (this.m_6782_(pState, pLevel, pPos) == 15 && !isInverted && isContainer || this.m_6782_(pState, pLevel, pPos) == 0 && isInverted && isContainer) {
                this.updateRailState(pLevel, pPos, true, pState);
            } else if (this.m_6782_(pState, pLevel, pPos) != 0 && isInverted && isContainer || this.m_6782_(pState, pLevel, pPos) != 15 && !isInverted && isContainer) {
                this.updateRailState(pLevel, pPos, false, pState);
            } else if (!isPowered && minecartFull && !isInverted && !isContainer || !isPowered && !minecartFull && isInverted && !isContainer) {
                this.updateRailState(pLevel, pPos, true, pState);
            } else if (isPowered && !minecartFull && !isInverted && !isContainer || isPowered && minecartFull && isInverted && !isContainer) {
                this.updateRailState(pLevel, pPos, false, pState);
            }
            pLevel.m_186460_(pPos, (Block)this, 0);
        }
        pLevel.m_46717_(pPos, (Block)this);
    }

    private void updateRailState(Level level, BlockPos pos, boolean powered, BlockState pState) {
        BlockState blockstate = (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
        level.m_46597_(pos, blockstate);
        this.updatePowerToConnected(level, pos, blockstate, true);
        level.m_46672_(pos, (Block)this);
        level.m_46672_(pos.m_7495_(), (Block)this);
        level.m_6550_(pos, pState, blockstate);
    }

    private <T extends CustomAbstractMinecartEntity> List<T> getInteractingMinecartOfType(Level pLevel, BlockPos pPos, Class<T> pCartType, Predicate<Entity> pFilter) {
        return pLevel.m_6443_(pCartType, this.getSearchBB(pPos), pFilter);
    }

    private AABB getSearchBB(BlockPos pPos) {
        double d0 = 0.2;
        return new AABB((double)pPos.m_123341_() + 0.2, (double)pPos.m_123342_(), (double)pPos.m_123343_() + 0.2, (double)(pPos.m_123341_() + 1) - 0.2, (double)(pPos.m_123342_() + 1) - 0.2, (double)(pPos.m_123343_() + 1) - 0.2);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            BlockState blockstate = this.m_49389_(pState, pLevel, pPos, pIsMoving);
            this.checkPressed(pLevel, pPos, blockstate);
        }
    }

    protected void updatePowerToConnected(Level pLevel, BlockPos pPos, BlockState pState, boolean pPowered) {
        RailState railstate = new RailState(pLevel, pPos, pState);
        for (BlockPos blockpos : railstate.m_55424_()) {
            BlockState blockstate = pLevel.m_8055_(blockpos);
            pLevel.m_213960_(blockstate, blockpos, blockstate.m_60734_(), pPos, false);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.checkPressed((Level)pLevel, pPos, pState);
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        if (!((Boolean)pBlockState.m_61143_((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return pSide == Direction.UP ? 15 : 0;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        List<CustomMinecartCommandBlockEntity> list = this.getInteractingMinecartOfType(pLevel, pPos, CustomMinecartCommandBlockEntity.class, p_153123_ -> true);
        if (!list.isEmpty()) {
            return list.get(0).getCommandBlock().m_45436_();
        }
        List<CustomAbstractMinecartEntity> carts = this.getInteractingMinecartOfType(pLevel, pPos, CustomAbstractMinecartEntity.class, e -> e.m_6084_());
        if (!carts.isEmpty() && carts.get(0).getComparatorLevel() > -1) {
            return carts.get(0).getComparatorLevel();
        }
        List list1 = carts.stream().filter(EntitySelector.f_20405_).collect(Collectors.toList());
        if (!list1.isEmpty()) {
            return AbstractContainerMenu.m_38938_((Container)((Container)list1.get(0)));
        }
        return 0;
    }
}

