/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.tieredshulkers.common.boxes.tile;

import ca.lukegrahamlandry.tieredshulkers.common.ShulkerColour;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxBlock;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxContainer;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxTier;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class UpgradableBoxTile
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private final int[] SLOTS;
    private NonNullList<ItemStack> items;
    private int openCount;
    private AnimationStatus animationStatus = AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    private boolean needsColorFromWorld;
    private ShulkerColour color;
    private UpgradableBoxTier tier;

    public UpgradableBoxTile(@Nullable ShulkerColour color, UpgradableBoxTier tier, BlockPos pos, BlockState state) {
        super(tier.tiles.get((Object)color).get(), pos, state);
        this.SLOTS = IntStream.range(0, tier.size).toArray();
        this.items = NonNullList.m_122780_((int)tier.size, (Object)ItemStack.f_41583_);
        this.color = color;
        this.tier = tier;
        if (color == null) {
            this.needsColorFromWorld = true;
        }
    }

    public void tick() {
        this.updateAnimation();
        if (this.animationStatus == AnimationStatus.OPENING || this.animationStatus == AnimationStatus.CLOSING) {
            this.moveCollidedEntities();
        }
    }

    protected void updateAnimation() {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (!(this.progress >= 1.0f)) break;
                this.moveCollidedEntities();
                this.animationStatus = AnimationStatus.OPENED;
                this.progress = 1.0f;
                this.updateNeighbors();
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                this.updateNeighbors();
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AABB getBoundingBox(BlockState blockState) {
        return this.getBoundingBox((Direction)blockState.m_61143_(UpgradableBoxBlock.FACING));
    }

    public AABB getBoundingBox(Direction directionIn) {
        float f = this.getProgress(1.0f);
        return Shapes.m_83144_().m_83215_().m_82363_((double)(0.5f * f * (float)directionIn.m_122429_()), (double)(0.5f * f * (float)directionIn.m_122430_()), (double)(0.5f * f * (float)directionIn.m_122431_()));
    }

    private AABB getTopBoundingBox(Direction directionIn) {
        Direction direction = directionIn.m_122424_();
        return this.getBoundingBox(directionIn).m_82310_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
    }

    private void moveCollidedEntities() {
        Direction direction;
        AABB axisalignedbb;
        List list;
        BlockState blockstate = this.f_58857_.m_8055_(this.m_58899_());
        if (blockstate.m_60734_() instanceof UpgradableBoxBlock && !(list = this.f_58857_.m_45933_((Entity)null, axisalignedbb = this.getTopBoundingBox(direction = (Direction)blockstate.m_61143_(UpgradableBoxBlock.FACING)).m_82338_(this.f_58858_))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_7752_() == PushReaction.IGNORE) continue;
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                AABB boundingBox = entity.m_20191_();
                switch (direction.m_122434_()) {
                    case X: {
                        d0 = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? axisalignedbb.f_82291_ - boundingBox.f_82288_ : boundingBox.f_82291_ - axisalignedbb.f_82288_;
                        d0 += 0.01;
                        break;
                    }
                    case Y: {
                        d1 = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? axisalignedbb.f_82292_ - boundingBox.f_82289_ : boundingBox.f_82292_ - axisalignedbb.f_82289_;
                        d1 += 0.01;
                        break;
                    }
                    case Z: {
                        d2 = direction.m_122421_() == Direction.AxisDirection.POSITIVE ? axisalignedbb.f_82293_ - boundingBox.f_82290_ : boundingBox.f_82293_ - axisalignedbb.f_82290_;
                        d2 += 0.01;
                    }
                }
                entity.m_6478_(MoverType.SHULKER_BOX, new Vec3(d0 * (double)direction.m_122429_(), d1 * (double)direction.m_122430_(), d2 * (double)direction.m_122431_()));
            }
        }
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            if (type == 0) {
                this.animationStatus = AnimationStatus.CLOSING;
                this.updateNeighbors();
            }
            if (type == 1) {
                this.animationStatus = AnimationStatus.OPENING;
                this.updateNeighbors();
            }
            return true;
        }
        return super.m_7531_(id, type);
    }

    private void updateNeighbors() {
        this.m_58900_().m_60701_((LevelAccessor)this.m_58904_(), this.m_58899_(), 3);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.openCount);
            if (this.openCount == 1) {
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12409_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.openCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.f_58857_.m_5594_((Player)null, this.f_58858_, SoundEvents.f_12408_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.shulkerBox");
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadFromNbt(compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveToNbt(compound);
    }

    public void loadFromNbt(CompoundTag compound) {
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compound) && compound.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        }
    }

    public CompoundTag saveToNbt(CompoundTag compound) {
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18976_((CompoundTag)compound, this.items, (boolean)false);
        }
        return compound;
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    public void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = NonNullList.m_122780_((int)this.getShulkerBoxType().size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < itemsIn.size(); ++i) {
            if (i >= this.items.size()) continue;
            this.m_7086_().set(i, (Object)((ItemStack)itemsIn.get(i)));
        }
    }

    public int[] m_7071_(Direction side) {
        return this.SLOTS;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return !(Block.m_49814_((Item)itemStackIn.m_41720_()) instanceof ShulkerBoxBlock) || !(Block.m_49814_((Item)itemStackIn.m_41720_()) instanceof UpgradableBoxBlock);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public float getProgress(float p_190585_1_) {
        return Mth.m_14179_((float)p_190585_1_, (float)this.progressOld, (float)this.progress);
    }

    @Nullable
    public ShulkerColour getColor() {
        if (this.needsColorFromWorld) {
            this.color = UpgradableBoxBlock.getColorFromBlock(this.m_58900_().m_60734_());
            this.needsColorFromWorld = false;
        }
        return this.color;
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return new UpgradableBoxContainer(this.tier, windowId, playerInventory, (Container)this);
    }

    protected IItemHandler createUnSidedHandler() {
        return new SidedInvWrapper((WorldlyContainer)this, Direction.UP);
    }

    public UpgradableBoxTier getShulkerBoxType() {
        UpgradableBoxTier typeNew;
        UpgradableBoxTier type = UpgradableBoxTier.IRON;
        if (this.m_58898_() && (typeNew = UpgradableBoxBlock.getTypeFromBlock(this.m_58900_().m_60734_())) != null) {
            type = typeNew;
        }
        return type;
    }

    public Block getBlockToUse() {
        return this.tier.blocks.get((Object)this.color).get();
    }

    public boolean isClosed() {
        return this.animationStatus == AnimationStatus.CLOSED;
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

