/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.tieredshulkers.common.boxes;

import ca.lukegrahamlandry.tieredshulkers.common.ShulkerColour;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxTier;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.tile.UpgradableBoxTile;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class UpgradableBoxBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = DirectionalBlock.f_52588_;
    public static final ResourceLocation CONTENTS = new ResourceLocation("tieredshulkers", "contents");
    private final UpgradableBoxTier tier;
    protected final ShulkerColour color;

    public UpgradableBoxBlock(ShulkerColour color, BlockBehaviour.Properties properties, UpgradableBoxTier type) {
        super(properties);
        this.color = color;
        this.tier = type;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.UP));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof UpgradableBoxTile) {
            boolean flag;
            Direction direction = (Direction)state.m_61143_(FACING);
            UpgradableBoxTile generictieredshulkersTileEntity = (UpgradableBoxTile)tileentity;
            if (generictieredshulkersTileEntity.getAnimationStatus() == UpgradableBoxTile.AnimationStatus.CLOSED) {
                AABB axisalignedbb = Shapes.m_83144_().m_83215_().m_82363_((double)(0.5f * (float)direction.m_122429_()), (double)(0.5f * (float)direction.m_122430_()), (double)(0.5f * (float)direction.m_122431_())).m_82310_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
                flag = worldIn.m_45772_(axisalignedbb.m_82338_(pos.m_121945_(direction)));
            } else {
                flag = true;
            }
            if (flag) {
                player.m_5893_((MenuProvider)generictieredshulkersTileEntity);
                player.m_36220_(Stats.f_12970_);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_43719_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof UpgradableBoxTile) {
            UpgradableBoxTile generictieredshulkersTileEntity = (UpgradableBoxTile)tileentity;
            if (!worldIn.f_46443_ && player.m_7500_() && !generictieredshulkersTileEntity.m_7983_()) {
                ItemStack itemstack = UpgradableBoxBlock.getColoredItemStack(this.getColor(), this.getTier());
                CompoundTag compoundnbt = generictieredshulkersTileEntity.saveToNbt(new CompoundTag());
                if (!compoundnbt.m_128456_()) {
                    itemstack.m_41700_("BlockEntityTag", (Tag)compoundnbt);
                }
                if (generictieredshulkersTileEntity.m_8077_()) {
                    itemstack.m_41714_(generictieredshulkersTileEntity.m_7770_());
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), itemstack);
                itementity.m_32060_();
                worldIn.m_7967_((Entity)itementity);
            } else {
                generictieredshulkersTileEntity.m_59640_(player);
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity tileentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (tileentity instanceof UpgradableBoxTile) {
            UpgradableBoxTile generictieredshulkersTileEntity = (UpgradableBoxTile)tileentity;
            builder = builder.m_78979_(CONTENTS, (p_220168_1_, p_220168_2_) -> {
                for (int i = 0; i < generictieredshulkersTileEntity.m_6643_(); ++i) {
                    p_220168_2_.accept(generictieredshulkersTileEntity.m_8020_(i));
                }
            });
        }
        return super.m_7381_(state, builder);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = worldIn.m_7702_(pos)) instanceof UpgradableBoxTile) {
            ((UpgradableBoxTile)tileentity).m_58638_(stack.m_41786_());
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof UpgradableBoxTile) {
                worldIn.m_46717_(pos, state.m_60734_());
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        CompoundTag compoundnbt = stack.m_41737_("BlockEntityTag");
        if (compoundnbt != null) {
            if (compoundnbt.m_128425_("LootTable", 8)) {
                tooltip.add((Component)Component.m_237113_((String)"???????"));
            }
            if (compoundnbt.m_128425_("Items", 9)) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundnbt, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.m_41619_()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    MutableComponent itextcomponent = itemstack.m_41786_().m_6881_();
                    itextcomponent.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                    tooltip.add((Component)itextcomponent);
                }
                if (j - i > 0) {
                    tooltip.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC));
                }
            }
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        return tileentity instanceof UpgradableBoxTile ? Shapes.m_83064_((AABB)((UpgradableBoxTile)tileentity).getBoundingBox(state)) : Shapes.m_83144_();
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return AbstractContainerMenu.m_38938_((Container)((Container)worldIn.m_7702_(pos)));
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.m_7397_(worldIn, pos, state);
        UpgradableBoxTile generictieredshulkersTileEntity = (UpgradableBoxTile)worldIn.m_7702_(pos);
        CompoundTag compoundnbt = generictieredshulkersTileEntity.saveToNbt(new CompoundTag());
        if (!compoundnbt.m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (Tag)compoundnbt);
        }
        return itemstack;
    }

    public static UpgradableBoxTier getTypeFromItem(Item itemIn) {
        return UpgradableBoxBlock.getTypeFromBlock(Block.m_49814_((Item)itemIn));
    }

    public static UpgradableBoxTier getTypeFromBlock(Block blockIn) {
        return blockIn instanceof UpgradableBoxBlock ? ((UpgradableBoxBlock)blockIn).getTier() : null;
    }

    public UpgradableBoxTier getTier() {
        return this.tier;
    }

    @javax.annotation.Nullable
    public static ShulkerColour getColorFromItem(Item itemIn) {
        return UpgradableBoxBlock.getColorFromBlock(Block.m_49814_((Item)itemIn));
    }

    @javax.annotation.Nullable
    public static ShulkerColour getColorFromBlock(Block blockIn) {
        return blockIn instanceof UpgradableBoxBlock ? ((UpgradableBoxBlock)blockIn).getColor() : null;
    }

    public static Block getBlockByColor(ShulkerColour colorIn, UpgradableBoxTier typeIn) {
        return typeIn.blocks.get((Object)colorIn).get();
    }

    @javax.annotation.Nullable
    public ShulkerColour getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(ShulkerColour colorIn, UpgradableBoxTier typeIn) {
        return new ItemStack((ItemLike)UpgradableBoxBlock.getBlockByColor(colorIn, typeIn));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_(FACING)));
    }

    public boolean m_8133_(BlockState state, Level worldIn, BlockPos pos, int id, int param) {
        super.m_8133_(state, worldIn, pos, id, param);
        BlockEntity tileentity = worldIn.m_7702_(pos);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    @javax.annotation.Nullable
    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        return tileentity instanceof MenuProvider ? (MenuProvider)tileentity : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.tier.tiles.get((Object)this.color).get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return UpgradableBoxBlock::ticker;
    }

    public static <T extends BlockEntity> void ticker(Level level, BlockPos pos, BlockState state, T tile) {
        if (tile instanceof UpgradableBoxTile) {
            ((UpgradableBoxTile)tile).tick();
        }
    }
}

