/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.tieredshulkers.common.boxes;

import ca.lukegrahamlandry.tieredshulkers.TieredShulkersMain;
import ca.lukegrahamlandry.tieredshulkers.common.ShulkerColour;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxBlock;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxContainer;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxItem;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxTier;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.tile.UpgradableBoxTile;
import ca.lukegrahamlandry.tieredshulkers.common.items.BoxUpgradeItem;
import ca.lukegrahamlandry.tieredshulkers.common.items.BoxUpgradeType;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ShulkerBoxesRegistry {
    private static final DeferredRegister<Block> BLOCK_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tieredshulkers");
    private static final DeferredRegister<BlockEntityType<?>> TILE_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"tieredshulkers");
    private static final DeferredRegister<Item> ITEM_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tieredshulkers");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"tieredshulkers");
    private static final BlockBehaviour.StatePredicate positionPredicate = (p_235444_0_, world, pos) -> !(world.m_7702_(pos) instanceof UpgradableBoxTile) || ((UpgradableBoxTile)world.m_7702_(pos)).isClosed();
    private static final BlockBehaviour.Properties PROPS = BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.0f, 3.0f).m_60988_().m_60955_().m_60960_(positionPredicate).m_60971_(positionPredicate);
    private static final BlockBehaviour.Properties OBSIDIAN_PROPS = BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(2.0f, 1000.0f).m_60988_().m_60955_().m_60960_(positionPredicate).m_60971_(positionPredicate);
    private static final Item.Properties ITEM_PROPS = new Item.Properties().m_41491_(TieredShulkersMain.ITEM_GROUP).m_41487_(1);
    public static final ImmutableMap<BoxUpgradeType, RegistryObject<BoxUpgradeItem>> UPGRADES = ImmutableMap.copyOf(Arrays.stream(BoxUpgradeType.values()).collect(Collectors.toMap(Function.identity(), type -> ITEM_REGISTRY.register(type.name().toLowerCase(Locale.ROOT) + "_shulker_box_upgrade", () -> new BoxUpgradeItem((BoxUpgradeType)((Object)type), new Item.Properties().m_41491_(TieredShulkersMain.ITEM_GROUP).m_41487_(1))))));

    public static void register(IEventBus bus) {
        BLOCK_REGISTRY.register(bus);
        ITEM_REGISTRY.register(bus);
        TILE_REGISTRY.register(bus);
        CONTAINERS.register(bus);
        ShulkerBoxesRegistry.createObjects();
    }

    private static void createObjects() {
        for (UpgradableBoxTier tier : UpgradableBoxTier.values()) {
            HashMap<ShulkerColour, RegistryObject> blocks = new HashMap<ShulkerColour, RegistryObject>();
            HashMap<ShulkerColour, RegistryObject> tiles = new HashMap<ShulkerColour, RegistryObject>();
            String key = tier.name + "_shulker_box";
            for (ShulkerColour color : ShulkerColour.values()) {
                String blockKey = key + "_" + color.getName();
                BlockBehaviour.Properties props = tier == UpgradableBoxTier.OBSIDIAN ? OBSIDIAN_PROPS : PROPS;
                RegistryObject block = BLOCK_REGISTRY.register(blockKey, () -> new UpgradableBoxBlock(color, props, tier));
                blocks.put(color, block);
                ITEM_REGISTRY.register(blockKey, () -> ShulkerBoxesRegistry.lambda$createObjects$2((Supplier)block));
                tiles.put(color, TILE_REGISTRY.register(blockKey, () -> BlockEntityType.Builder.m_155273_((pos, state) -> new UpgradableBoxTile(color, tier, pos, state), (Block[])((Block[])blocks.values().stream().map(Supplier::get).toArray(Block[]::new))).m_58966_(null)));
            }
            tier.blocks = blocks;
            tier.tiles = tiles;
            tier.menu = CONTAINERS.register(key, () -> new MenuType((windowId, playerInv) -> new UpgradableBoxContainer(tier, windowId, playerInv, (Container)new SimpleContainer(tier.size))));
        }
    }

    private static /* synthetic */ UpgradableBoxItem lambda$createObjects$2(Supplier block) {
        return new UpgradableBoxItem((Block)block.get(), ITEM_PROPS);
    }
}

