/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.tieredshulkers.client.tileentity;

import ca.lukegrahamlandry.tieredshulkers.client.tileentity.BoxesModels;
import ca.lukegrahamlandry.tieredshulkers.common.ShulkerColour;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxBlock;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.UpgradableBoxTier;
import ca.lukegrahamlandry.tieredshulkers.common.boxes.tile.UpgradableBoxTile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UpgradableBoxTileEntityRenderer
implements BlockEntityRenderer<UpgradableBoxTile> {
    private final ShulkerModel<?> model;

    public UpgradableBoxTileEntityRenderer(BlockEntityRendererProvider.Context p_173626_) {
        this.model = new ShulkerModel(p_173626_.m_173582_(ModelLayers.f_171180_));
    }

    public void render(UpgradableBoxTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate;
        Direction direction = Direction.UP;
        if (tileEntityIn.m_58898_() && (blockstate = tileEntityIn.m_58904_().m_8055_(tileEntityIn.m_58899_())).m_60734_() instanceof UpgradableBoxBlock) {
            direction = (Direction)blockstate.m_61143_(UpgradableBoxBlock.FACING);
        }
        BlockState blockState = tileEntityIn.m_58898_() ? tileEntityIn.m_58900_() : (BlockState)tileEntityIn.getBlockToUse().m_49966_().m_61124_(UpgradableBoxBlock.FACING, (Comparable)Direction.NORTH);
        UpgradableBoxTier boxType = UpgradableBoxTier.IRON;
        UpgradableBoxTier typeFromTileEntity = tileEntityIn.getShulkerBoxType();
        UpgradableBoxTier typeFromBlock = UpgradableBoxBlock.getTypeFromBlock(blockState.m_60734_());
        if (typeFromTileEntity != null) {
            boxType = typeFromTileEntity;
        }
        if ((boxType != typeFromBlock || typeFromTileEntity != typeFromBlock) && typeFromBlock != null) {
            boxType = typeFromBlock;
        }
        ShulkerColour dyecolor = tileEntityIn.getColor();
        Material material = new Material(Sheets.f_110735_, BoxesModels.chooseShulkerBoxModel(boxType, dyecolor.getId()));
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        matrixStackIn.m_85841_(0.9995f, 0.9995f, 0.9995f);
        matrixStackIn.m_85845_(direction.m_122406_());
        matrixStackIn.m_85841_(1.0f, -1.0f, -1.0f);
        matrixStackIn.m_85837_(0.0, -1.0, 0.0);
        ModelPart modelpart = this.model.m_103742_();
        modelpart.m_104227_(0.0f, 24.0f - tileEntityIn.getProgress(partialTicks) * 0.5f * 16.0f, 0.0f);
        modelpart.f_104204_ = 270.0f * tileEntityIn.getProgress(partialTicks) * ((float)Math.PI / 180);
        VertexConsumer vertexconsumer = material.m_119194_(bufferIn, RenderType::m_110458_);
        this.model.m_7695_(matrixStackIn, vertexconsumer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }
}

