/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.serialize;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.framework.api.serialize.DataArray;
import com.mrcrayfish.framework.api.serialize.DataBoolean;
import com.mrcrayfish.framework.api.serialize.DataEntry;
import com.mrcrayfish.framework.api.serialize.DataNumber;
import com.mrcrayfish.framework.api.serialize.DataString;
import com.mrcrayfish.framework.api.serialize.DataType;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public final class DataObject
extends DataEntry {
    public static final DataObject EMPTY = new DataObject((ImmutableMap<String, DataEntry>)ImmutableMap.of());
    private final ImmutableMap<String, DataEntry> children;

    DataObject(JsonObject object) {
        this(DataObject.construct(object));
    }

    private DataObject(ImmutableMap<String, DataEntry> children) {
        super(DataType.OBJECT);
        this.children = children;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public Set<String> keys() {
        return this.children.keySet();
    }

    public Collection<DataEntry> values() {
        return this.children.values();
    }

    public void forEach(BiConsumer<String, DataEntry> consumer) {
        this.children.forEach(consumer);
    }

    public boolean has(String key, DataType type) {
        DataEntry entry = (DataEntry)this.children.get((Object)key);
        return entry != null && entry.getType() == type;
    }

    @Nullable
    public DataEntry get(String key) {
        return (DataEntry)this.children.get((Object)key);
    }

    @Nullable
    public DataObject getDataObject(String key) {
        return (DataObject)this.children.get((Object)key);
    }

    @Nullable
    public DataArray getDataArray(String key) {
        return (DataArray)this.children.get((Object)key);
    }

    @Nullable
    public DataString getDataString(String key) {
        return (DataString)this.children.get((Object)key);
    }

    @Nullable
    public DataNumber getDataNumber(String key) {
        return (DataNumber)this.children.get((Object)key);
    }

    @Nullable
    public DataBoolean getDataBoolean(String key) {
        return (DataBoolean)this.children.get((Object)key);
    }

    @Nullable
    public static DataObject convert(@Nullable JsonElement element) {
        if (element != null && element.isJsonObject()) {
            return new DataObject(element.getAsJsonObject());
        }
        return null;
    }

    private static ImmutableMap<String, DataEntry> construct(JsonObject object) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        object.entrySet().forEach((? super T mapEntry) -> {
            DataEntry entry = DataObject.convertElement((JsonElement)mapEntry.getValue());
            if (entry != null) {
                builder.put((Object)((String)mapEntry.getKey()), (Object)entry);
            }
        });
        return builder.build();
    }
}

