/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.misc;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DripstoneSplatterFeature
extends Feature<NoneFeatureConfiguration> {
    public DripstoneSplatterFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel worldIn = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos pos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        int i = 0;
        int j = rand.m_188503_(6) + 2;
        for (int k = pos.m_123341_() - j; k <= pos.m_123341_() + j; ++k) {
            block1: for (int l = pos.m_123343_() - j; l <= pos.m_123343_() + j; ++l) {
                int j1;
                int i1 = k - pos.m_123341_();
                if (i1 * i1 + (j1 = l - pos.m_123343_()) * j1 > j * j) continue;
                for (int k1 = pos.m_123342_() - 2; k1 <= pos.m_123342_() + 2; ++k1) {
                    BlockPos blockpos = new BlockPos(k, k1, l);
                    BlockState blockstate = worldIn.m_8055_(blockpos);
                    BlockState blockstate1 = worldIn.m_8055_(blockpos.m_7494_());
                    if (blockstate.m_60734_() != Blocks.f_50440_) continue;
                    if (!DripstoneSplatterFeature.isAir((LevelSimulatedReader)worldIn, blockpos.m_7494_())) continue;
                    worldIn.m_7731_(blockpos, Blocks.f_152537_.m_49966_(), 2);
                    if (rand.m_188503_(5) == 0) {
                        int height;
                        for (int ii = height = 1 + rand.m_188503_(8); ii > 0; --ii) {
                            BlockPos dripPos = blockpos.m_6630_(ii);
                            worldIn.m_7731_(dripPos, (BlockState)Blocks.f_152588_.m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154010_, (Comparable)DripstoneSplatterFeature.calculateDripstoneThickness((LevelReader)worldIn, dripPos, Direction.UP, false)), 2);
                        }
                    }
                    ++i;
                    continue block1;
                }
            }
        }
        return i > 0;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader p_154093_, BlockPos p_154094_, Direction p_154095_, boolean p_154096_) {
        Direction direction = p_154095_.m_122424_();
        BlockState blockstate = p_154093_.m_8055_(p_154094_.m_121945_(p_154095_));
        if (DripstoneSplatterFeature.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !p_154096_ && blockstate.m_61143_((Property)PointedDripstoneBlock.f_154010_) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!DripstoneSplatterFeature.isPointedDripstoneWithDirection(blockstate, p_154095_)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.m_61143_((Property)PointedDripstoneBlock.f_154010_);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = p_154093_.m_8055_(p_154094_.m_121945_(direction));
            return !DripstoneSplatterFeature.isPointedDripstoneWithDirection(blockstate1, p_154095_) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState p_154208_, Direction p_154209_) {
        return p_154208_.m_60713_(Blocks.f_152588_) && p_154208_.m_61143_((Property)PointedDripstoneBlock.f_154009_) == p_154209_;
    }

    public static boolean isAir(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }
}

