/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers;

import com.mojang.math.Matrix4f;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import java.nio.FloatBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;

public class McObjectConverter {
    static final Direction[] directions;
    static final EDhDirection[] lodDirections;

    private static int bufferIndex(int x, int y) {
        return y * 4 + x;
    }

    @Deprecated
    public static Mat4f Convert(Matrix4f mcMatrix) {
        FloatBuffer buffer = FloatBuffer.allocate(16);
        McObjectConverter.storeMatrix(mcMatrix, buffer);
        Mat4f matrix = new Mat4f(buffer);
        matrix.transpose();
        return matrix;
    }

    private static void storeMatrix(Matrix4f matrix, FloatBuffer buffer) {
        matrix.m_27650_(buffer);
    }

    public static BlockPos Convert(DhBlockPos wrappedPos) {
        return new BlockPos(wrappedPos.getX(), wrappedPos.getY(), wrappedPos.getZ());
    }

    public static ChunkPos Convert(DhChunkPos wrappedPos) {
        return new ChunkPos(wrappedPos.getX(), wrappedPos.getZ());
    }

    public static Direction Convert(EDhDirection lodDirection) {
        return directions[lodDirection.ordinal()];
    }

    public static EDhDirection Convert(Direction direction) {
        return lodDirections[direction.ordinal()];
    }

    static {
        EDhDirection[] lodDirs = EDhDirection.values();
        directions = new Direction[lodDirs.length];
        lodDirections = new EDhDirection[lodDirs.length];
        for (EDhDirection lodDir : lodDirs) {
            Direction dir = switch (lodDir.name().toUpperCase()) {
                case "DOWN" -> Direction.DOWN;
                case "UP" -> Direction.UP;
                case "NORTH" -> Direction.NORTH;
                case "SOUTH" -> Direction.SOUTH;
                case "WEST" -> Direction.WEST;
                case "EAST" -> Direction.EAST;
                default -> null;
            };
            if (dir == null) {
                throw new IllegalArgumentException("Invalid direction on init mapping: " + String.valueOf((Object)lodDir));
            }
            McObjectConverter.directions[lodDir.ordinal()] = dir;
            McObjectConverter.lodDirections[dir.ordinal()] = lodDir;
        }
    }
}

