/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.texture;

import DistantHorizons.libraries.joml.Vector2i;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhInternalTextureFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhPixelFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhPixelType;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL43C;

public class DhColorTexture {
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private final EDhInternalTextureFormat internalFormat;
    private final EDhPixelFormat format;
    private final EDhPixelType type;
    private int width;
    private int height;
    private boolean isValid = true;
    private final int id;
    private static final ByteBuffer NULL_BUFFER = null;

    public DhColorTexture(Builder builder) {
        this.internalFormat = builder.internalFormat;
        this.format = builder.format;
        this.type = builder.type;
        this.width = builder.width;
        this.height = builder.height;
        this.id = GL43C.glGenTextures();
        boolean isPixelFormatInteger = builder.internalFormat.getPixelFormat().isInteger();
        this.setupTexture(this.id, builder.width, builder.height, !isPixelFormatInteger);
        GL43C.glBindTexture((int)3553, (int)0);
    }

    private void setupTexture(int id, int width, int height, boolean allowsLinear) {
        this.resizeTexture(id, width, height);
        GL43C.glTexParameteri((int)3553, (int)10241, (int)(allowsLinear ? 9729 : 9728));
        GL43C.glTexParameteri((int)3553, (int)10240, (int)(allowsLinear ? 9729 : 9728));
        GL43C.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL43C.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    private void resizeTexture(int texture, int width, int height) {
        GL43C.glBindTexture((int)3553, (int)texture);
        GL43C.glTexImage2D((int)3553, (int)0, (int)this.internalFormat.getGlFormat(), (int)width, (int)height, (int)0, (int)this.format.getGlFormat(), (int)this.type.getGlFormat(), (ByteBuffer)NULL_BUFFER);
    }

    void resize(Vector2i textureScaleOverride) {
        this.resize(textureScaleOverride.x, textureScaleOverride.y);
    }

    public void resize(int width, int height) {
        this.throwIfInvalid();
        this.width = width;
        this.height = height;
        this.resizeTexture(this.id, width, height);
    }

    public EDhInternalTextureFormat getInternalFormat() {
        return this.internalFormat;
    }

    public int getTextureId() {
        this.throwIfInvalid();
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void destroy() {
        this.throwIfInvalid();
        this.isValid = false;
        GLMC.glDeleteTextures(this.id);
    }

    private void throwIfInvalid() {
        if (!this.isValid) {
            throw new IllegalStateException("Attempted to use a deleted composite render target");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private EDhInternalTextureFormat internalFormat = EDhInternalTextureFormat.RGBA8;
        private int width = 0;
        private int height = 0;
        private EDhPixelFormat format = EDhPixelFormat.RGBA;
        private EDhPixelType type = EDhPixelType.UNSIGNED_BYTE;

        private Builder() {
        }

        public Builder setInternalFormat(EDhInternalTextureFormat format) {
            this.internalFormat = format;
            return this;
        }

        public Builder setDimensions(int width, int height) {
            if (width <= 0) {
                throw new IllegalArgumentException("Width must be greater than zero");
            }
            if (height <= 0) {
                throw new IllegalArgumentException("Height must be greater than zero");
            }
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setPixelFormat(EDhPixelFormat pixelFormat) {
            this.format = pixelFormat;
            return this;
        }

        public Builder setPixelType(EDhPixelType pixelType) {
            this.type = pixelType;
            return this;
        }

        public DhColorTexture build() {
            return new DhColorTexture(this);
        }
    }
}

