/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;

public class InitSentryAnimation {
    private BlockPos pos;
    public boolean animate;
    public boolean animateUpwards;
    public boolean isShutDown;

    public InitSentryAnimation() {
    }

    public InitSentryAnimation(BlockPos sentryPos, boolean animate, boolean animateUpwards, boolean isShutDown) {
        this.pos = sentryPos;
        this.animate = animate;
        this.animateUpwards = animateUpwards;
        this.isShutDown = isShutDown;
    }

    public static void encode(InitSentryAnimation message, FriendlyByteBuf buf) {
        buf.writeLong(message.pos.m_121878_());
        buf.writeBoolean(message.animate);
        buf.writeBoolean(message.animateUpwards);
        buf.writeBoolean(message.isShutDown);
    }

    public static InitSentryAnimation decode(FriendlyByteBuf buf) {
        InitSentryAnimation message = new InitSentryAnimation();
        message.pos = BlockPos.m_122022_((long)buf.readLong());
        message.animate = buf.readBoolean();
        message.animateUpwards = buf.readBoolean();
        message.isShutDown = buf.readBoolean();
        return message;
    }

    public static void onMessage(InitSentryAnimation message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            List sentries = Minecraft.m_91087_().f_91073_.m_45976_(Sentry.class, new AABB(message.pos));
            if (!sentries.isEmpty()) {
                Sentry sentry = (Sentry)sentries.get(0);
                sentry.setShutDown(message.isShutDown);
                sentry.animateUpwards = message.animateUpwards;
                sentry.animate = message.animate;
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

