/*
 * Decompiled with CFR 0.152.
 */
package ic2.probeplugin.info.transport;

import ic2.api.tiles.tubes.TransportedItem;
import ic2.api.util.DirectionList;
import ic2.core.block.machines.recipes.ItemStackStrategy;
import ic2.core.block.transport.item.TubeTileEntity;
import ic2.core.block.transport.item.tubes.ColorFilterTubeTileEntity;
import ic2.core.block.transport.item.tubes.DirectionalTubeTileEntity;
import ic2.core.block.transport.item.tubes.ExtractionTubeTileEntity;
import ic2.core.block.transport.item.tubes.FilterTubeTileEntity;
import ic2.core.block.transport.item.tubes.FilteredExtractionTubeTileEntity;
import ic2.core.block.transport.item.tubes.InsertionTubeTileEntity;
import ic2.core.block.transport.item.tubes.LimiterTubeTileEntity;
import ic2.core.block.transport.item.tubes.PickupTubeTileEntity;
import ic2.core.block.transport.item.tubes.RequestTubeTileEntity;
import ic2.core.block.transport.item.tubes.RoundRobinTubeTileEntity;
import ic2.core.block.transport.item.tubes.StackingTubeTileEntity;
import ic2.core.block.transport.item.tubes.TeleportTubeTileEntity;
import ic2.core.utils.collection.CollectionUtils;
import ic2.core.utils.helpers.StackUtil;
import ic2.core.utils.math.MathUtils;
import ic2.probeplugin.base.ProbePluginHelper;
import ic2.probeplugin.info.ITileInfoComponent;
import ic2.probeplugin.override.IExpandedProbeInfo;
import ic2.probeplugin.override.components.Panel;
import ic2.probeplugin.styles.IC2Styles;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mcjty.theoneprobe.api.Color;
import mcjty.theoneprobe.api.IProbeInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TubeProvider
implements ITileInfoComponent<TubeTileEntity> {
    @Override
    public void addInfo(IProbeInfo info, Player player, Direction dir, TubeTileEntity tile) {
        Object filters;
        TubeTileEntity filter;
        Object object;
        TubeTileEntity extraction;
        int priority;
        Panel panel = new Panel(IC2Styles.OUTER_STYLE, Panel.Type.VERTICAL);
        Panel inner = new Panel(IC2Styles.SLOTS_STYLE.copy().borderColor((Color)null), Panel.Type.VERTICAL);
        Object2ObjectSortedMap<MutableComponent, Object> slots = CollectionUtils.createLinkedMap();
        IExpandedProbeInfo data = panel.vertical(IC2Styles.INNER_STYLE);
        if (!tile.synchronize) {
            data.text((Component)this.translate("ic2.probe.tube.invisible").m_130940_(ChatFormatting.RED));
        }
        if ((priority = tile.getPrioritySide()) > 0) {
            data.text((Component)this.translate("ic2.probe.tube.direction.prio", ChatFormatting.GOLD).m_7220_((Component)this.translate("misc.ic2.side." + Direction.m_122376_((int)(priority - 1)), IC2Styles.getColor(priority - 1))));
        }
        if (tile instanceof DirectionalTubeTileEntity) {
            DirectionalTubeTileEntity tube = (DirectionalTubeTileEntity)tile;
            data.text((Component)this.translate("ic2.probe.tube.direction", ChatFormatting.GOLD).m_7220_((Component)this.translate("misc.ic2.side." + tube.getFacing().m_122433_(), IC2Styles.getColor(tube.getFacing().m_122411_()))));
            data.text((Component)this.translate("ic2.probe.tube.blocked", ChatFormatting.DARK_AQUA).m_7220_((Component)this.translate(tube.isBlocked() ? "misc.ic2.yes" : "misc.ic2.no", tube.isBlocked() ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
        if (tile instanceof ExtractionTubeTileEntity) {
            extraction = (ExtractionTubeTileEntity)tile;
            data.text((Component)this.translate("ic2.probe.tube.redstone.control", ChatFormatting.GOLD).m_7220_((Component)this.translate(tile.sensitive ? "misc.ic2.yes" : "misc.ic2.no", tile.sensitive ? ChatFormatting.GREEN : ChatFormatting.RED)));
            if (tile.sensitive) {
                data.text((Component)this.translate("ic2.probe.tube.redstone.comparator", ChatFormatting.LIGHT_PURPLE).m_7220_((Component)this.translate(extraction.comparator ? "misc.ic2.yes" : "misc.ic2.no", extraction.comparator ? ChatFormatting.GREEN : ChatFormatting.RED)));
                data.text((Component)this.translate("ic2.probe.tube.redstone.pulse", ChatFormatting.LIGHT_PURPLE).m_7220_((Component)this.translate(extraction.pulse ? "misc.ic2.yes" : "misc.ic2.no", extraction.pulse ? ChatFormatting.GREEN : ChatFormatting.RED)));
            }
        }
        if (tile instanceof FilteredExtractionTubeTileEntity) {
            extraction = (FilteredExtractionTubeTileEntity)tile;
            data.text((Component)this.translate("ic2.probe.tube.redstone.control", ChatFormatting.GOLD).m_7220_((Component)this.translate(tile.sensitive ? "misc.ic2.yes" : "misc.ic2.no", tile.sensitive ? ChatFormatting.GREEN : ChatFormatting.RED)));
            if (tile.sensitive) {
                data.text((Component)this.translate("ic2.probe.tube.redstone.comparator", ChatFormatting.LIGHT_PURPLE).m_7220_((Component)this.translate(((FilteredExtractionTubeTileEntity)extraction).comparator ? "misc.ic2.yes" : "misc.ic2.no", ((FilteredExtractionTubeTileEntity)extraction).comparator ? ChatFormatting.GREEN : ChatFormatting.RED)));
                data.text((Component)this.translate("ic2.probe.tube.redstone.pulse", ChatFormatting.LIGHT_PURPLE).m_7220_((Component)this.translate(((FilteredExtractionTubeTileEntity)extraction).pulse ? "misc.ic2.yes" : "misc.ic2.no", ((FilteredExtractionTubeTileEntity)extraction).pulse ? ChatFormatting.GREEN : ChatFormatting.RED)));
            }
            data.text((Component)this.translate("ic2.probe.tube.redstone.comparator", ChatFormatting.LIGHT_PURPLE).m_7220_((Component)this.translate(((FilteredExtractionTubeTileEntity)extraction).comparator ? "misc.ic2.yes" : "misc.ic2.no", ((FilteredExtractionTubeTileEntity)extraction).comparator ? ChatFormatting.GREEN : ChatFormatting.RED)));
            data.padding(0, 5).text((Component)this.translate("ic2.probe.tube.filter.whitelist", ChatFormatting.GOLD).m_7220_((Component)this.translate(((FilteredExtractionTubeTileEntity)extraction).whitelist ? "misc.ic2.yes" : "misc.ic2.no", ((FilteredExtractionTubeTileEntity)extraction).whitelist ? ChatFormatting.GREEN : ChatFormatting.RED)));
            data.padding(0, -5);
            Long2ObjectAVLTreeMap mappedFilters = new Long2ObjectAVLTreeMap();
            object = ((FilteredExtractionTubeTileEntity)extraction).filters.iterator();
            while (object.hasNext()) {
                FilteredExtractionTubeTileEntity.FilterEntry filterEntry = (FilteredExtractionTubeTileEntity.FilterEntry)object.next();
                ((List)mappedFilters.computeIfAbsent(MathUtils.putIntoLong(filterEntry.getFlags() & 0xFFFFFFFB, filterEntry.getKeepItems()), T -> CollectionUtils.createList())).add(filterEntry);
            }
            for (Long2ObjectMap.Entry entry : mappedFilters.long2ObjectEntrySet()) {
                long infoData = entry.getLongKey();
                int flags = MathUtils.getIntKey(infoData);
                int keep = MathUtils.getIntValue(infoData);
                MutableComponent text = this.string().m_130940_(ChatFormatting.GOLD);
                text.m_7220_((Component)this.translate(flags == 0 ? "ic2.probe.tube.filter.basic" : "ic2.probe.tube.filter.adv"));
                if ((flags & 0x10) != 0) {
                    text.m_7220_((Component)this.translate("ic2.probe.tube.filter.nbt"));
                }
                if ((flags & 0x80) != 0) {
                    text.m_7220_((Component)this.translate("ic2.probe.tube.filter.fluid"));
                }
                if ((flags & 0x100) != 0) {
                    text.m_7220_((Component)this.translate("ic2.probe.tube.filter.durability"));
                }
                if (keep > 0) {
                    text.m_7220_((Component)this.translate("ic2.probe.tube.filter.keep", keep));
                }
                ObjectList result = CollectionUtils.createList();
                for (FilteredExtractionTubeTileEntity.FilterEntry filterEntry : (List)entry.getValue()) {
                    result.add((ItemStack)filterEntry.getStack());
                }
                slots.put(text, result);
            }
        }
        if (tile instanceof StackingTubeTileEntity) {
            StackingTubeTileEntity stacking = (StackingTubeTileEntity)tile;
            data.text((Component)this.translate("ic2.probe.tube.stacking.color", ChatFormatting.GOLD).m_7220_((Component)this.translate(stacking.ignoreColors ? "misc.ic2.yes" : "misc.ic2.no", stacking.ignoreColors ? ChatFormatting.GREEN : ChatFormatting.RED)));
            data.text((Component)this.translate("ic2.probe.tube.stacking.limit", ChatFormatting.GOLD, new Object[]{"" + ChatFormatting.AQUA + stacking.stacking}));
        }
        if (tile instanceof PickupTubeTileEntity) {
            PickupTubeTileEntity pickup = (PickupTubeTileEntity)tile;
            data.text((Component)this.translate("ic2.probe.tube.pickup.large", ChatFormatting.GOLD).m_7220_((Component)this.translate(pickup.largeRadius ? "misc.ic2.yes" : "misc.ic2.no", pickup.largeRadius ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
        if (tile instanceof FilterTubeTileEntity) {
            filter = (FilterTubeTileEntity)tile;
            filters = new EnumMap<Direction, List>(Direction.class);
            object = filter.stacks.iterator();
            while (object.hasNext()) {
                FilterTubeTileEntity.FilterEntry filterEntry = (FilterTubeTileEntity.FilterEntry)object.next();
                for (Direction side : filterEntry.getSides()) {
                    filters.computeIfAbsent((Direction)side, T -> CollectionUtils.createList()).add(filterEntry.getStack());
                }
            }
            for (Map.Entry entry : filters.entrySet()) {
                slots.put(DirectionList.getName((Direction)entry.getKey()).m_130940_(IC2Styles.getColor(((Direction)entry.getKey()).m_122411_())).m_130946_(": "), (List)entry.getValue());
            }
            data.text((Component)this.translate("ic2.probe.tube.inv_priority", ChatFormatting.GOLD).m_7220_((Component)this.translate(filter.invPriority ? "misc.ic2.yes" : "misc.ic2.no", filter.invPriority ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
        if (tile instanceof ColorFilterTubeTileEntity) {
            filter = (ColorFilterTubeTileEntity)tile;
            filters = new EnumMap(Direction.class);
            for (int i = 0; i < 16; ++i) {
                ItemStack itemStack = new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)i)));
                for (Direction side : DirectionList.ofNumber(((ColorFilterTubeTileEntity)filter).colorDirections[i])) {
                    filters.computeIfAbsent((Direction)side, T -> CollectionUtils.createList()).add(itemStack);
                }
            }
            for (Map.Entry entry : filters.entrySet()) {
                slots.put(DirectionList.getName((Direction)entry.getKey()).m_130940_(IC2Styles.getColor(((Direction)entry.getKey()).m_122411_())).m_130946_(": "), (List)entry.getValue());
            }
            data.text((Component)this.translate("ic2.probe.tube.inv_priority", ChatFormatting.GOLD).m_7220_((Component)this.translate(((ColorFilterTubeTileEntity)filter).invPriority ? "misc.ic2.yes" : "misc.ic2.no", ((ColorFilterTubeTileEntity)filter).invPriority ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
        if (tile instanceof RoundRobinTubeTileEntity) {
            RoundRobinTubeTileEntity robin = (RoundRobinTubeTileEntity)tile;
            data.text((Component)this.translate("ic2.probe.tube.robin.rules", ChatFormatting.GOLD));
            data.text((Component)this.translate("ic2.probe.tube.robin.side", ChatFormatting.GOLD, new Object[]{DirectionList.getName(Direction.m_122376_((int)robin.currentIndex)).m_130940_(IC2Styles.getColor(robin.currentIndex))}));
            data.text((Component)this.translate("ic2.probe.tube.robin.count", ChatFormatting.GOLD, new Object[]{"" + ChatFormatting.AQUA + Math.max(0, robin.currentItem)}));
            for (Direction side : DirectionList.ALL) {
                data.text((Component)DirectionList.getName(side).m_130946_(": " + robin.cap[side.ordinal()]).m_130940_(IC2Styles.getColor(side.m_122411_())));
            }
        }
        if (tile instanceof TeleportTubeTileEntity) {
            TeleportTubeTileEntity teleport = (TeleportTubeTileEntity)tile;
            int filter2 = teleport.state;
            boolean isPrivate = (filter2 & 4) != 0;
            boolean bl = (filter2 & 2) != 0;
            boolean canSend = (filter2 & 1) != 0;
            data.text((Component)this.translate("ic2.probe.tube.teleport.network", ChatFormatting.GOLD, new Object[]{ChatFormatting.AQUA + teleport.frequency}));
            data.text((Component)this.translate("ic2.probe.tube.teleport.private", ChatFormatting.GOLD).m_7220_((Component)this.translate(isPrivate ? "misc.ic2.yes" : "misc.ic2.no", isPrivate ? ChatFormatting.GREEN : ChatFormatting.RED)));
            data.text((Component)this.translate("ic2.probe.tube.teleport.send", ChatFormatting.GOLD).m_7220_((Component)this.translate(canSend ? "misc.ic2.yes" : "misc.ic2.no", canSend ? ChatFormatting.GREEN : ChatFormatting.RED)));
            data.text((Component)this.translate("ic2.probe.tube.teleport.receive", ChatFormatting.GOLD).m_7220_((Component)this.translate(bl ? "misc.ic2.yes" : "misc.ic2.no", bl ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
        if (tile.items.size() > 0) {
            Object2IntLinkedOpenCustomHashMap mapped = new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)ItemStackStrategy.INSTANCE);
            int m = tile.items.size();
            for (int i = 0; i < m; ++i) {
                TransportedItem transportedItem = (TransportedItem)tile.items.get(i);
                mapped.addTo((Object)StackUtil.copyWithSize(transportedItem.getServerStack(), 1), transportedItem.getServerStack().m_41613_());
            }
            NonNullList list = NonNullList.m_122779_();
            mapped.forEach((K, V) -> list.add((Object)StackUtil.copyWithSize(K, V)));
            slots.put(this.translate("ic2.probe.tube.transported"), list);
        }
        if (tile instanceof StackingTubeTileEntity) {
            StackingTubeTileEntity stackingTile = (StackingTubeTileEntity)tile;
            if (!stackingTile.cached.isEmpty()) {
                NonNullList cached = NonNullList.m_122779_();
                ObjectListIterator objectListIterator = stackingTile.cached.iterator();
                while (objectListIterator.hasNext()) {
                    StackingTubeTileEntity.StackingStack stackingStack = (StackingTubeTileEntity.StackingStack)objectListIterator.next();
                    cached.add((Object)StackUtil.copyWithSize(stackingStack.getStack(), stackingStack.getAmount()));
                }
                slots.put(this.translate("ic2.probe.tube.cached"), cached);
            }
        }
        if (tile instanceof LimiterTubeTileEntity) {
            LimiterTubeTileEntity limiter = (LimiterTubeTileEntity)tile;
            ObjectList list = CollectionUtils.createList();
            ObjectListIterator objectListIterator = limiter.usedColors.iterator();
            while (objectListIterator.hasNext()) {
                DyeColor dyeColor = (DyeColor)objectListIterator.next();
                list.add((ItemStack)new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)dyeColor)));
            }
            slots.put(this.translate("ic2.probe.tube.limiter.unblocked"), list);
        }
        if (tile instanceof InsertionTubeTileEntity) {
            InsertionTubeTileEntity insertion = (InsertionTubeTileEntity)tile;
            data.text((Component)this.translate("ic2.probe.tube.inserter.existing", ChatFormatting.GOLD).m_7220_((Component)this.translate(insertion.onlyExistingOne ? "misc.ic2.yes" : "misc.ic2.no", insertion.onlyExistingOne ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
        if (tile instanceof RequestTubeTileEntity) {
            RequestTubeTileEntity request = (RequestTubeTileEntity)tile;
            NonNullList list = NonNullList.m_122779_();
            ObjectListIterator objectListIterator = request.filters.iterator();
            while (objectListIterator.hasNext()) {
                RequestTubeTileEntity.RequestEntry requestEntry = (RequestTubeTileEntity.RequestEntry)objectListIterator.next();
                list.add((Object)StackUtil.copyWithSize(requestEntry.getStack(), requestEntry.getAmount()));
            }
            if (!list.isEmpty()) {
                slots.put(this.translate("ic2.probe.tube.requests"), list);
            }
            list = NonNullList.m_122779_();
            request.getMissing((NonNullList<ItemStack>)list);
            if (!list.isEmpty()) {
                slots.put(this.translate("ic2.probe.tube.missing"), list);
            }
            list = NonNullList.m_122779_();
            for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(request.requested)) {
                list.add((Object)StackUtil.copyWithSize((ItemStack)entry.getKey(), entry.getIntValue()));
            }
            if (!list.isEmpty()) {
                slots.put(this.translate("ic2.probe.tube.requesting"), list);
            }
            if (request.toInsert.size() > 0) {
                list = NonNullList.m_122779_();
                for (ItemStack itemStack : request.toInsert) {
                    list.add((Object)itemStack.m_41777_());
                }
                slots.put(this.translate("ic2.probe.tube.stuck"), list);
            }
            data.text((Component)this.translate("ic2.probe.tube.redstone.control", ChatFormatting.GOLD).m_7220_((Component)this.translate(request.redstoneRequest ? "misc.ic2.yes" : "misc.ic2.no", request.redstoneRequest ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
        ProbePluginHelper.generateSlotInfo(slots, inner);
        panel.element(inner);
        this.addSecurely(info, 1, panel);
    }
}

