/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.planner;

import ic2.api.reactor.IReactorPlannerComponent;
import ic2.api.reactor.planner.BaseHeatSimulatedStack;
import ic2.api.reactor.planner.ISimulatedReactor;
import ic2.api.reactor.planner.SimulatedStack;
import ic2.core.item.reactor.base.ExchangerProperty;
import ic2.core.item.reactor.planner.SimulatedCoord;
import ic2.core.utils.collection.CollectionUtils;
import ic2.core.utils.math.geometry.Vec2i;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class SimulatedHeatBalancer
extends BaseHeatSimulatedStack {
    ExchangerProperty property;

    public SimulatedHeatBalancer(ExchangerProperty property) {
        super(property.getComponentID(), property.getHeatStorage());
        this.property = property;
    }

    @Override
    public ItemStack syncStack(ItemStack original) {
        original.m_41721_(this.heat);
        return original;
    }

    @Override
    public void simulate(ISimulatedReactor reactor, int x, int y, boolean heatTick, boolean damageTick) {
        ObjectArrayList insert = new ObjectArrayList();
        ObjectArrayList extract = new ObjectArrayList();
        List<Vec2i> offsets = this.property.getOffsets();
        int m = offsets.size();
        for (int i = 0; i < m; ++i) {
            Vec2i pos = offsets.get(i);
            this.fetchInfo(reactor, x + pos.getX(), y + pos.getY(), (List<SimulatedCoord.SimulatedDirCoord>)insert, (List<SimulatedCoord.SimulatedDirCoord>)extract);
        }
        int myHeat = 0;
        myHeat = this.processStep(reactor, x, y, myHeat, false, (List<SimulatedCoord.SimulatedDirCoord>)insert);
        myHeat = this.processStep(reactor, x, y, myHeat, true, (List<SimulatedCoord.SimulatedDirCoord>)extract);
        this.storeHeat(reactor, x, y, myHeat);
    }

    protected int processStep(ISimulatedReactor reactor, int x, int y, int myHeat, boolean absorb, List<SimulatedCoord.SimulatedDirCoord> process) {
        int side = this.property.getSelf();
        int react = this.property.getReactor();
        double med = (double)this.getStoredHeat(reactor, x, y) / (double)this.getMaxStoredHeat(reactor, x, y);
        int c = 1;
        boolean didReactor = false;
        if (react > 0) {
            double avg = (double)reactor.getHeat() / (double)reactor.getMaxHeat();
            if (absorb ? avg >= 0.75 : avg <= 0.25) {
                ++c;
                med += avg;
                didReactor = true;
            }
        }
        if (side > 0) {
            int m = process.size();
            for (int i = 0; i < m; ++i) {
                med += process.get(i).average();
            }
        }
        med /= (double)(c + process.size());
        if (side > 0) {
            for (SimulatedCoord.SimulatedDirCoord coord : process) {
                int add = Mth.m_14045_((int)coord.getTransferRate(reactor, med), (int)(-side), (int)side);
                myHeat -= add;
                myHeat += coord.storeHeat(reactor, add);
            }
        }
        if (react > 0 && didReactor) {
            int add = Mth.m_14045_((int)((int)(med * (double)reactor.getMaxHeat() - (double)reactor.getHeat())), (int)(-react), (int)react);
            myHeat -= add;
            reactor.setHeat(reactor.getHeat() + add);
        }
        return myHeat;
    }

    private void fetchInfo(ISimulatedReactor reactor, int x, int y, List<SimulatedCoord.SimulatedDirCoord> insert, List<SimulatedCoord.SimulatedDirCoord> extract) {
        SimulatedStack comp = reactor.getItem(x, y);
        if (comp != null && comp.canStoreHeat(reactor, x, y)) {
            double max = comp.getMaxStoredHeat(reactor, x, y);
            if (max <= 0.0) {
                return;
            }
            double average = (double)comp.getStoredHeat(reactor, x, y) / max;
            if (average <= 0.25) {
                insert.add(new SimulatedCoord.SimulatedDirCoord(comp, x, y, average));
            } else if (average >= 0.75) {
                extract.add(new SimulatedCoord.SimulatedDirCoord(comp, x, y, average));
            }
        }
    }

    @Override
    public List<IReactorPlannerComponent.ReactorStat> getStats() {
        return CollectionUtils.asList(IReactorPlannerComponent.ReactorStat.REACTOR_BALANCING, IReactorPlannerComponent.ReactorStat.PART_BALANCING);
    }

    @Override
    public IReactorPlannerComponent.ReactorType getValidType() {
        return IReactorPlannerComponent.ReactorType.UNIVERSAL;
    }

    @Override
    public IReactorPlannerComponent.ComponentType getComponentType() {
        return IReactorPlannerComponent.ComponentType.HEAT_EXCHANGER;
    }

    @Override
    public NumericTag getStat(IReactorPlannerComponent.ReactorStat stat) {
        if (stat == IReactorPlannerComponent.ReactorStat.REACTOR_BALANCING) {
            return IntTag.m_128679_((int)this.property.getReactor());
        }
        if (stat == IReactorPlannerComponent.ReactorStat.PART_BALANCING) {
            return IntTag.m_128679_((int)this.property.getSelf());
        }
        return NULL_VALUE;
    }
}

