/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.tiles.teleporter;

import ic2.api.tiles.teleporter.TeleporterTarget;
import ic2.core.utils.collection.NBTListWrapper;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TargetRegistry
extends SavedData {
    Map<TeleporterTarget, String> names = new Object2ObjectLinkedOpenHashMap();

    public TargetRegistry() {
    }

    public TargetRegistry(CompoundTag tag) {
        for (CompoundTag nbt : NBTListWrapper.wrap(tag.m_128437_("names", 10), CompoundTag.class)) {
            TeleporterTarget target = TeleporterTarget.read(nbt);
            if (target == null) continue;
            this.names.put(target, nbt.m_128461_("name"));
        }
    }

    public void addTarget(TeleporterTarget target, String name) {
        this.names.put(target, name);
    }

    public void removeTarget(TeleporterTarget target) {
        this.names.remove(target);
    }

    public String getTargetName(TeleporterTarget target) {
        return this.names.get(target);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<TeleporterTarget, String> entry : this.names.entrySet()) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("target", (Tag)entry.getKey().write());
            nbt.m_128359_("name", entry.getValue());
            list.add((Object)nbt);
        }
        tag.m_128365_("names", (Tag)list);
        return tag;
    }

    public static TargetRegistry getRegistry() {
        return (TargetRegistry)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(TargetRegistry::new, TargetRegistry::new, "ic2_teleporter_names");
    }
}

