/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.WorkThread;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.module.ModuleDescriptor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class UpdateChecker {
    public static boolean runUpdateCheckBlocking(String url, String versionString) {
        if (!Configuration.instance().general.enableUpdateChecker) {
            return false;
        }
        StringBuilder changelog = new StringBuilder();
        if (versionString.endsWith("-SNAPSHOT")) {
            DiscordIntegration.LOGGER.info("You are using a development version of the mod. Will not check for updates!");
        } else {
            try {
                ModuleDescriptor.Version curVer = ModuleDescriptor.Version.parse(versionString);
                HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                conn.setRequestMethod("GET");
                InputStreamReader r = new InputStreamReader(conn.getInputStream());
                JsonArray parse = JsonParser.parseReader((Reader)r).getAsJsonArray();
                if (parse == null) {
                    DiscordIntegration.LOGGER.error("Could not check for updates");
                    return false;
                }
                AtomicBoolean shouldNotify = new AtomicBoolean(false);
                AtomicInteger versionsBehind = new AtomicInteger();
                parse.forEach(elm -> {
                    if (elm != null && elm.isJsonObject()) {
                        JsonObject versionDetails = elm.getAsJsonObject();
                        ModuleDescriptor.Version version = ModuleDescriptor.Version.parse(versionDetails.get("version").getAsString());
                        try {
                            int n = curVer.compareTo(version);
                            if (n < 0) {
                                versionsBehind.getAndIncrement();
                                changelog.append("\n").append(version).append(":\n").append(versionDetails.get("changelog").getAsString()).append("\n");
                                if (!shouldNotify.get() && ReleaseType.getFromName((String)versionDetails.get((String)"type").getAsString()).value >= Configuration.instance().general.updateCheckerMinimumReleaseType.value) {
                                    shouldNotify.set(true);
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                });
                String changelogString = changelog.toString();
                if (shouldNotify.get()) {
                    DiscordIntegration.LOGGER.info("Updates available! You are " + versionsBehind.get() + " version" + (versionsBehind.get() == 1 ? "" : "s") + " behind\nChangelog since last update:\n" + changelogString);
                    return true;
                }
            }
            catch (IOException e) {
                DiscordIntegration.LOGGER.info("Could not check for updates");
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void runUpdateCheck(String url) {
        if (!Configuration.instance().general.enableUpdateChecker) {
            return;
        }
        WorkThread.executeJob(() -> UpdateChecker.runUpdateCheckBlocking(url, DiscordIntegration.VERSION));
    }

    public static enum ReleaseType {
        alpha(0),
        beta(1),
        release(2);

        public final int value;

        private ReleaseType(int val) {
            this.value = val;
        }

        public static ReleaseType getFromName(String name) {
            for (ReleaseType t : ReleaseType.values()) {
                if (!name.equalsIgnoreCase(t.name())) continue;
                return t;
            }
            return beta;
        }
    }
}

