/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.util;

import dcshadow.club.minnced.discord.webhook.send.AllowedMentions;
import dcshadow.club.minnced.discord.webhook.send.WebhookEmbed;
import dcshadow.club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import dcshadow.club.minnced.discord.webhook.send.WebhookMessageBuilder;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;

public final class DiscordMessage {
    private final boolean isNotRaw;
    private MessageEmbed embed;
    private boolean isSystemMessage = true;
    private String message;

    public DiscordMessage(MessageEmbed embed, String message, boolean isNotRaw) {
        this.embed = embed;
        this.message = message;
        this.isNotRaw = isNotRaw;
    }

    public DiscordMessage(MessageEmbed embed, String message) {
        this(embed, message, false);
    }

    public DiscordMessage(String message) {
        this(null, message, false);
    }

    public DiscordMessage(MessageEmbed embed) {
        this(embed, "", false);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setIsChatMessage() {
        this.isSystemMessage = false;
    }

    public MessageEmbed getEmbed() {
        return this.embed;
    }

    public void setEmbed(MessageEmbed embed) {
        this.embed = embed;
    }

    public MessageCreateData buildMessages() {
        MessageCreateBuilder out = new MessageCreateBuilder();
        if (!this.isSystemMessage) {
            ArrayList<Message.MentionType> mentions = new ArrayList<Message.MentionType>();
            mentions.add(Message.MentionType.USER);
            mentions.add(Message.MentionType.CHANNEL);
            mentions.add(Message.MentionType.EMOJI);
            out.setAllowedMentions(mentions);
        } else {
            out.setAllowedMentions(Arrays.asList(Message.MentionType.values()));
        }
        if (!this.message.isEmpty()) {
            if (this.isNotRaw) {
                out.setContent(MessageUtils.convertMCToMarkdown(this.message));
            } else {
                out.setContent(this.message);
            }
        }
        if (this.embed != null) {
            out.setEmbeds(this.embed);
        }
        return out.build();
    }

    private String[] splitMessages(String inMsg) {
        if (inMsg.length() <= 2000) {
            return new String[]{inMsg};
        }
        String[] split = inMsg.split(" ");
        ArrayList<String> outStrings = new ArrayList<String>();
        StringBuilder bufferString = new StringBuilder();
        for (String s : split) {
            if ((bufferString + " " + s).length() > 2000) {
                outStrings.add(bufferString.toString());
                bufferString = new StringBuilder(" ");
                continue;
            }
            bufferString.append(s);
        }
        outStrings.add(bufferString.toString());
        return outStrings.toArray(new String[0]);
    }

    public ArrayList<WebhookMessageBuilder> buildWebhookMessages() {
        ArrayList<WebhookMessageBuilder> out = new ArrayList<WebhookMessageBuilder>();
        if (!this.message.isEmpty()) {
            String content = this.isNotRaw ? MessageUtils.convertMCToMarkdown(this.message) : this.message;
            for (String msg : this.splitMessages(content)) {
                out.add(new WebhookMessageBuilder().setContent(msg).setAllowedMentions(this.isSystemMessage ? AllowedMentions.all() : AllowedMentions.none().withParseUsers(true)));
            }
        }
        if (this.embed != null) {
            WebhookEmbedBuilder eb = new WebhookEmbedBuilder();
            if (this.embed.getAuthor() != null) {
                eb.setAuthor(new WebhookEmbed.EmbedAuthor(this.embed.getAuthor().getName(), this.embed.getAuthor().getIconUrl(), this.embed.getAuthor().getUrl()));
            }
            eb.setColor(this.embed.getColorRaw());
            eb.setDescription(this.embed.getDescription());
            if (this.embed.getFooter() != null) {
                eb.setFooter(new WebhookEmbed.EmbedFooter(this.embed.getFooter().getText(), this.embed.getFooter().getIconUrl()));
            }
            if (this.embed.getImage() != null) {
                eb.setImageUrl(this.embed.getImage().getUrl());
            }
            if (this.embed.getThumbnail() != null) {
                eb.setThumbnailUrl(this.embed.getThumbnail().getUrl());
            }
            for (MessageEmbed.Field f : this.embed.getFields()) {
                eb.addField(new WebhookEmbed.EmbedField(f.isInline(), f.getName(), f.getValue()));
            }
            eb.setTimestamp(this.embed.getTimestamp());
            if (this.embed.getTitle() != null) {
                eb.setTitle(new WebhookEmbed.EmbedTitle(this.embed.getTitle(), this.embed.getUrl()));
            }
            if (out.isEmpty()) {
                out.add(new WebhookMessageBuilder().setAllowedMentions(this.isSystemMessage ? AllowedMentions.all() : AllowedMentions.none().withParseUsers(true)).addEmbeds(eb.build()));
            } else {
                out.set(out.size() - 1, out.get(out.size() - 1).setAllowedMentions(this.isSystemMessage ? AllowedMentions.all() : AllowedMentions.none().withParseUsers(true)).addEmbeds(eb.build()));
            }
        }
        return out;
    }
}

