/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common;

import dcshadow.dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializer;
import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.TextComponent;
import dcshadow.net.kyori.adventure.text.TextReplacementConfig;
import dcshadow.net.kyori.adventure.text.event.ClickEvent;
import dcshadow.net.kyori.adventure.text.event.HoverEvent;
import dcshadow.net.kyori.adventure.text.format.Style;
import dcshadow.net.kyori.adventure.text.format.TextColor;
import dcshadow.net.kyori.adventure.text.format.TextDecoration;
import dcshadow.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import dcshadow.org.apache.commons.lang3.ArrayUtils;
import dcshadow.org.jetbrains.annotations.NotNull;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.api.DiscordEventHandler;
import de.erdbeerbaerlp.dcintegration.common.discordCommands.DiscordCommand;
import de.erdbeerbaerlp.dcintegration.common.storage.CommandRegistry;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.ComponentUtils;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import java.util.List;
import java.util.UUID;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.entities.sticker.Sticker;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.events.guild.member.GenericGuildMemberEvent;
import net.dv8tion.jda.api.events.guild.member.GuildMemberRemoveEvent;
import net.dv8tion.jda.api.events.guild.member.GuildMemberUpdateEvent;
import net.dv8tion.jda.api.events.interaction.GenericInteractionCreateEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.GenericMessageEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.react.GenericMessageReactionEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.hooks.EventListener;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;

class DiscordEventListener
implements EventListener {
    DiscordEventListener() {
    }

    @Override
    public void onEvent(GenericEvent event) {
        Event ev;
        DiscordIntegration dc = DiscordIntegration.INSTANCE;
        JDA jda = dc.getJDA();
        if (jda == null) {
            return;
        }
        if (event instanceof GuildMemberUpdateEvent) {
            ev = (GuildMemberUpdateEvent)event;
            DiscordIntegration.memberCache.replace(((GenericGuildMemberEvent)ev).getMember().getIdLong(), ((GenericGuildMemberEvent)ev).getMember());
        }
        if (event instanceof SlashCommandInteractionEvent) {
            ev = (SlashCommandInteractionEvent)event;
            if (!Configuration.instance().commands.enabled) {
                return;
            }
            if (ev.getChannelType().equals((Object)ChannelType.TEXT) && CommandRegistry.registeredCMDs.containsKey(ev.getCommandId())) {
                DiscordCommand cfCommand = CommandRegistry.registeredCMDs.get(ev.getCommandId());
                String cmd = cfCommand.getName();
                String args2 = ev.getOption("args") != null ? ev.getOption("args").getAsString() : "";
                this.processDiscordCommand((SlashCommandInteractionEvent)ev, ArrayUtils.addAll(new String[]{cmd}, args2.split(" ")), ((SlashCommandInteractionEvent)ev).getChannel(), ((GenericInteractionCreateEvent)ev).getUser(), dc);
            }
        }
        if (event instanceof MessageReactionAddEvent) {
            ev = (MessageReactionAddEvent)event;
            UUID sender = dc.getSenderUUIDFromMessageID(((GenericMessageEvent)ev).getMessageId());
            if (((GenericMessageEvent)ev).getChannel().getId().equals(Configuration.instance().advanced.chatOutputChannelID.equals("default") ? Configuration.instance().general.botChannel : Configuration.instance().advanced.chatOutputChannelID) && sender != DiscordIntegration.dummyUUID && !LinkManager.getLink((String)((GenericMessageReactionEvent)ev).getUserId(), null).settings.ignoreReactions) {
                dc.getServerInterface().sendIngameReaction(((GenericMessageReactionEvent)ev).retrieveMember().complete(), ((GenericMessageReactionEvent)ev).retrieveMessage(), sender, ((GenericMessageReactionEvent)ev).getEmoji());
            }
        }
        if (event instanceof GuildMemberRemoveEvent) {
            ev = (GuildMemberRemoveEvent)event;
            if (Configuration.instance().linking.unlinkOnLeave && LinkManager.isDiscordUserLinked(((GuildMemberRemoveEvent)ev).getUser().getId())) {
                LinkManager.unlinkPlayer(((GuildMemberRemoveEvent)event).getUser().getId());
            }
        }
        if (event instanceof MessageReceivedEvent) {
            ev = (MessageReceivedEvent)event;
            if (Localization.instance().ingame_discordMessage.isBlank()) {
                return;
            }
            if ((Configuration.instance().general.allowWebhookMessages && !dc.recentMessages.containsKey(((GenericMessageEvent)ev).getMessageId()) || !((MessageReceivedEvent)ev).isWebhookMessage()) && !((MessageReceivedEvent)ev).getAuthor().getId().equals(jda.getSelfUser().getId())) {
                if (dc.callEvent(arg_0 -> DiscordEventListener.lambda$onEvent$0((MessageReceivedEvent)ev, arg_0))) {
                    return;
                }
                if (((GenericMessageEvent)ev).getChannel().getId().equals(Configuration.instance().advanced.chatInputChannelID.equals("default") ? dc.getChannel().getId() : Configuration.instance().advanced.chatInputChannelID)) {
                    List<MessageEmbed> embeds = ((MessageReceivedEvent)ev).getMessage().getEmbeds();
                    String msg = ((MessageReceivedEvent)ev).getMessage().getContentDisplay();
                    msg = MessageUtils.formatEmoteMessage(((MessageReceivedEvent)ev).getMessage().getMentions().getCustomEmojis(), msg);
                    Component attachmentComponent = DiscordEventListener.getAttachmentComp((MessageReceivedEvent)ev, embeds);
                    Component outMsg = MinecraftSerializer.INSTANCE.serialize(msg.replace("\n", "\\n"), DiscordIntegration.mcSerializerOptions);
                    Message reply = ((MessageReceivedEvent)ev).getMessage().getReferencedMessage();
                    boolean hasReply = reply != null;
                    Component out = LegacyComponentSerializer.legacySection().deserialize(hasReply ? Localization.instance().ingame_discordReplyMessage : Localization.instance().ingame_discordMessage);
                    int memberColor = ((MessageReceivedEvent)ev).getMember() != null ? ((MessageReceivedEvent)ev).getMember().getColorRaw() : 0;
                    TextReplacementConfig msgReplacer = ComponentUtils.replaceLiteral("%msg%", ComponentUtils.makeURLsClickable(outMsg.replaceText(ComponentUtils.replaceLiteral("\\n", Component.newline()))));
                    TextReplacementConfig idReplacer = ComponentUtils.replaceLiteral("%id%", ((MessageReceivedEvent)ev).getAuthor().getId());
                    Style.Builder memberStyle = Style.style();
                    if (Configuration.instance().messages.discordRoleColorIngame) {
                        memberStyle.color(TextColor.color(memberColor));
                    }
                    Component user = Component.text(((MessageReceivedEvent)ev).getMember() != null ? ((MessageReceivedEvent)ev).getMember().getEffectiveName() : ((MessageReceivedEvent)ev).getAuthor().getName());
                    if (Configuration.instance().messages.enableHoverMessage) {
                        user = user.style((Style.Builder)memberStyle.clickEvent(ClickEvent.suggestCommand("<@" + ((MessageReceivedEvent)ev).getAuthor().getId() + ">")).hoverEvent(HoverEvent.showText(Component.text(Localization.instance().discordUserHover.replace("%username%", ((MessageReceivedEvent)ev).getMember().getEffectiveName()).replace("%user#tag%", !((MessageReceivedEvent)ev).getAuthor().getDiscriminator().equals("0000") ? ((MessageReceivedEvent)ev).getAuthor().getAsTag() : ((MessageReceivedEvent)ev).getAuthor().getName()).replace("%user%", ((MessageReceivedEvent)ev).getMember() == null ? ((MessageReceivedEvent)ev).getAuthor().getEffectiveName() : ((MessageReceivedEvent)ev).getMember().getEffectiveName()).replace("%id%", ((MessageReceivedEvent)ev).getAuthor().getId())))));
                    }
                    if (((MessageReceivedEvent)ev).getAuthor().isBot()) {
                        user = ComponentUtils.append(user, Component.text("[BOT]").style((Style)Style.style(TextColors.DISCORD_BLURPLE).hoverEvent(HoverEvent.showText(Component.text(Localization.instance().bot)))));
                    }
                    TextReplacementConfig userReplacer = ComponentUtils.replaceLiteral("%user%", user);
                    out = out.replaceText(userReplacer).replaceText(idReplacer).replaceText(msgReplacer);
                    if (hasReply) {
                        Member replyMember = reply.isWebhookMessage() ? null : dc.getMemberById(reply.getAuthor().getIdLong());
                        memberStyle = Style.style();
                        if (Configuration.instance().messages.discordRoleColorIngame) {
                            memberStyle.color(TextColor.color(replyMember != null ? replyMember.getColorRaw() : 0));
                        }
                        Component repUser = Component.text(replyMember != null ? replyMember.getEffectiveName() : reply.getAuthor().getName()).style(ComponentUtils.addUserHoverClick(memberStyle.build(), reply.getAuthor(), replyMember));
                        out = out.replaceText(ComponentUtils.replaceLiteral("%ruser%", repUser));
                        String repMsg = MessageUtils.formatEmoteMessage(reply.getMentions().getCustomEmojis(), reply.getContentDisplay());
                        Component replyMsg = MinecraftSerializer.INSTANCE.serialize(repMsg.replace("\n", "\\n"), DiscordIntegration.mcSerializerOptions);
                        out = out.replaceText(ComponentUtils.replaceLiteral("%rmsg%", ComponentUtils.makeURLsClickable(replyMsg.replaceText(ComponentUtils.replaceLiteral("\\n", Component.newline())))));
                    }
                    out = ComponentUtils.append(out, attachmentComponent);
                    dc.getServerInterface().sendIngameMessage(out);
                }
                dc.callEventC(arg_0 -> DiscordEventListener.lambda$onEvent$1((MessageReceivedEvent)ev, arg_0));
            }
        }
    }

    @NotNull
    private static Component getAttachmentComp(MessageReceivedEvent ev, List<MessageEmbed> embeds) {
        Component attachmentComponent = Component.empty();
        if (!ev.getMessage().getAttachments().isEmpty()) {
            attachmentComponent = ComponentUtils.append(attachmentComponent, Component.newline());
            attachmentComponent = ComponentUtils.append(attachmentComponent, Component.text(Localization.instance().attachment + ":").decorate(TextDecoration.UNDERLINED));
        }
        for (Message.Attachment attachment : ev.getMessage().getAttachments()) {
            attachmentComponent = ComponentUtils.append(attachmentComponent, Component.newline());
            attachmentComponent = ComponentUtils.append(attachmentComponent, ((TextComponent)((TextComponent)Component.text(attachment.getFileName()).decorate(TextDecoration.UNDERLINED)).color(TextColor.color(6, 69, 173))).clickEvent(ClickEvent.openUrl(attachment.getUrl())));
        }
        for (MessageEmbed messageEmbed : embeds) {
            if (messageEmbed.isEmpty()) continue;
            attachmentComponent = ComponentUtils.append(attachmentComponent, Component.text("\n-----[" + Localization.instance().embed + "]-----\n"));
            if (messageEmbed.getAuthor() != null && messageEmbed.getAuthor().getName() != null && !messageEmbed.getAuthor().getName().trim().isEmpty()) {
                attachmentComponent = ComponentUtils.append(attachmentComponent, ((TextComponent)Component.text(messageEmbed.getAuthor().getName() + "\n").decorate(TextDecoration.BOLD)).decorate(TextDecoration.ITALIC));
            }
            if (messageEmbed.getTitle() != null && !messageEmbed.getTitle().trim().isEmpty()) {
                attachmentComponent = ComponentUtils.append(attachmentComponent, Component.text(messageEmbed.getTitle() + "\n").decorate(TextDecoration.BOLD));
            }
            if (messageEmbed.getDescription() != null && !messageEmbed.getDescription().trim().isEmpty()) {
                attachmentComponent = ComponentUtils.append(attachmentComponent, Component.text(Localization.instance().embedMessage + ":\n" + messageEmbed.getDescription() + "\n"));
            }
            if (messageEmbed.getImage() != null && messageEmbed.getImage().getUrl() != null && !messageEmbed.getImage().getUrl().isEmpty()) {
                attachmentComponent = ComponentUtils.append(attachmentComponent, Component.text(Localization.instance().embedImage + ": " + messageEmbed.getImage().getUrl() + "\n"));
            }
            attachmentComponent = ComponentUtils.append(attachmentComponent, Component.text("\n-----------------"));
        }
        for (Sticker sticker : ev.getMessage().getStickers()) {
            attachmentComponent = ComponentUtils.append(attachmentComponent, Component.text("\n" + Localization.instance().sticker + ": " + sticker.getName()));
        }
        return attachmentComponent;
    }

    private void processDiscordCommand(SlashCommandInteractionEvent ev, String[] command, MessageChannelUnion channel, User sender, DiscordIntegration dc) {
        boolean hasPermission = true;
        boolean executed = false;
        ReplyCallbackAction replyCallbackAction = ev.deferReply();
        for (DiscordCommand cmd : CommandRegistry.getCommandList()) {
            if (!cmd.getName().equals(command[0])) continue;
            if (cmd.canUserExecuteCommand(sender)) {
                if (dc.callEvent(e -> e.onDiscordCommand(channel, sender, cmd))) {
                    return;
                }
                cmd.execute(ev, replyCallbackAction);
                executed = true;
                continue;
            }
            hasPermission = false;
        }
        if (!executed && dc.callEvent(e -> e.onDiscordCommand(channel, sender, null))) {
            return;
        }
        if (!hasPermission) {
            ((ReplyCallbackAction)replyCallbackAction.setContent(Localization.instance().commands.noPermission)).setEphemeral(true).queue();
        }
    }

    private static /* synthetic */ void lambda$onEvent$1(MessageReceivedEvent ev, DiscordEventHandler e) {
        e.onDiscordMessagePost(ev);
    }

    private static /* synthetic */ Boolean lambda$onEvent$0(MessageReceivedEvent ev, DiscordEventHandler e) {
        return e.onDiscordMessagePre(ev);
    }
}

