/*
 * Decompiled with CFR 0.152.
 */
package dcshadow.net.kyori.adventure.text.serializer;

import dcshadow.net.kyori.adventure.text.Component;
import dcshadow.net.kyori.adventure.text.serializer.ComponentEncoder;
import dcshadow.org.jetbrains.annotations.ApiStatus;
import dcshadow.org.jetbrains.annotations.Contract;
import dcshadow.org.jetbrains.annotations.NotNull;
import dcshadow.org.jetbrains.annotations.Nullable;

public interface ComponentSerializer<I extends Component, O extends Component, R>
extends ComponentEncoder<I, R> {
    @NotNull
    public O deserialize(@NotNull R var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    @Contract(value="!null -> !null; null -> null", pure=true)
    @Nullable
    default public O deseializeOrNull(@Nullable R input) {
        return this.deserializeOrNull(input);
    }

    @Contract(value="!null -> !null; null -> null", pure=true)
    @Nullable
    default public O deserializeOrNull(@Nullable R input) {
        return this.deserializeOr(input, null);
    }

    @Contract(value="!null, _ -> !null; null, _ -> param2", pure=true)
    @Nullable
    default public O deserializeOr(@Nullable R input, @Nullable O fallback) {
        if (input == null) {
            return fallback;
        }
        return this.deserialize(input);
    }

    @Override
    @NotNull
    public R serialize(@NotNull I var1);

    @Override
    @Contract(value="!null -> !null; null -> null", pure=true)
    @Nullable
    default public R serializeOrNull(@Nullable I component) {
        return this.serializeOr(component, null);
    }

    @Override
    @Contract(value="!null, _ -> !null; null, _ -> param2", pure=true)
    @Nullable
    default public R serializeOr(@Nullable I component, @Nullable R fallback) {
        if (component == null) {
            return fallback;
        }
        return this.serialize(component);
    }
}

