/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.ftbchunks.FTBChunksProtectionCheck;
import com.yogpc.qp.integration.wrench.WrenchItems;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.Direction8;
import com.yogpc.qp.machines.EnchantedLootFunction;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.machines.module.ContainerQuarryModule;
import com.yogpc.qp.machines.module.EnergyModuleItem;
import com.yogpc.qp.machines.module.ModuleLootFunction;
import com.yogpc.qp.machines.quarry.FrameBlock;
import com.yogpc.qp.machines.quarry.QuarryItem;
import com.yogpc.qp.machines.quarry.QuarryLootFunction;
import com.yogpc.qp.machines.quarry.QuarryState;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.MapMulti;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class QuarryBlock
extends QPBlock
implements EntityBlock {
    public static final String NAME = "quarry";

    public QuarryBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.5f, 10.0f).m_60918_(SoundType.f_56742_), NAME, QuarryItem::new);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WORKING, BlockStateProperties.f_61372_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_43723_() == null ? Direction.NORTH : ctx.m_43723_().m_6350_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.f_46443_ && !this.disallowedDim().contains(level.m_46472_().m_135782_())) {
            Direction facing = entity == null ? Direction.NORTH : entity.m_6350_().m_122424_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof TileQuarry) {
                TileQuarry quarry = (TileQuarry)blockEntity;
                quarry.setEnchantments(EnchantmentHelper.m_44831_((ItemStack)stack));
                quarry.setTileDataFromItem(BlockItem.m_186336_((ItemStack)stack));
                Area area = QuarryBlock.findArea(level, pos, facing.m_122424_(), quarry.storage::addItem);
                if (FTBChunksProtectionCheck.isAreaProtected(area, (ResourceKey<Level>)level.m_46472_())) {
                    if (entity instanceof Player) {
                        player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"quarryplus.chat.warn_protected_area"), false);
                    }
                } else if (area.maxX() - area.minX() > 1 && area.maxZ() - area.minZ() > 1) {
                    quarry.setState(QuarryState.WAITING, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing));
                    quarry.setArea(area);
                } else if (entity instanceof Player) {
                    player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"quarryplus.chat.warn_area"), false);
                }
                quarry.updateModules();
                boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos, quarry.enabled);
                quarry.setChunkPreLoaded(preForced);
                quarry.sync();
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_()) && ((Boolean)QuarryPlus.config.common.removeFrameAfterQuarryIsRemoved.get()).booleanValue()) {
            for (Direction8 dir : Direction8.DIRECTIONS) {
                BlockPos offset = pos.m_121955_(dir.vec());
                BlockState maybeFrame = level.m_8055_(offset);
                if (!maybeFrame.m_60713_((Block)Holder.BLOCK_FRAME) || ((Boolean)maybeFrame.m_61143_((Property)FrameBlock.DAMMING)).booleanValue()) continue;
                level.m_7471_(offset, false);
            }
        }
        super.m_6810_(state, level, pos, newState, moved);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!world.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.m_49954_()}), true);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        if (WrenchItems.isWrenchItem(stack)) {
            BlockEntity blockEntity;
            if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TileQuarry) {
                TileQuarry quarry = (TileQuarry)blockEntity;
                quarry.setState(QuarryState.WAITING, state);
                quarry.target = null;
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_()) {
            BlockEntity blockEntity;
            if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TileQuarry) {
                TileQuarry quarry = (TileQuarry)blockEntity;
                ContainerQuarryModule.InteractionObject.openScreen(quarry, (ServerPlayer)player, (Component)this.m_49954_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Holder.QUARRY_TYPE.m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            if (blockEntityType == Holder.QUARRY_TYPE) {
                BlockEntityTicker ticker = TileQuarry::clientTick;
                return ticker;
            }
            return null;
        }
        return QuarryBlock.checkType(blockEntityType, Holder.QUARRY_TYPE, CombinedBlockEntityTicker.of(this, level, PowerTile.getGenerator(), EnergyModuleItem.energyModuleTicker(), TileQuarry::tick, PowerTile.logTicker(), MachineStorage.passItems(), MachineStorage.passFluid()));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileQuarry) {
            TileQuarry quarry = (TileQuarry)blockEntity;
            QuarryLootFunction.process(stack, quarry);
            EnchantedLootFunction.process(stack, quarry);
            ModuleLootFunction.process(stack, quarry);
        }
        return stack;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.m_6861_(state, world, pos, block, fromPos, notify);
        if (!world.f_46443_) {
            world.m_141902_(pos, Holder.QUARRY_TYPE).ifPresent(TileQuarry::updateModules);
        }
    }

    static Area findArea(Level world, BlockPos pos, Direction quarryBehind, Consumer<ItemStack> itemCollector) {
        return Stream.of(quarryBehind, quarryBehind.m_122428_(), quarryBehind.m_122427_()).map(arg_0 -> ((BlockPos)pos).m_121945_(arg_0)).map(arg_0 -> ((Level)world).m_7702_(arg_0)).mapMulti(MapMulti.cast(QuarryMarker.class)).flatMap(m -> m.getArea().stream().peek(a -> m.removeAndGetItems().forEach(itemCollector))).findFirst().map(a -> a.assureY(4)).orElse(new Area((Vec3i)pos.m_121945_(quarryBehind).m_5484_(quarryBehind.m_122428_(), 5), (Vec3i)pos.m_5484_(quarryBehind, 11).m_5484_(quarryBehind.m_122427_(), 5).m_5484_(Direction.UP, 4), quarryBehind));
    }
}

