/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.util;

import com.mrcrayfish.framework.api.client.FrameworkClientAPI;
import com.mrcrayfish.framework.api.serialize.DataArray;
import com.mrcrayfish.framework.api.serialize.DataEntry;
import com.mrcrayfish.framework.api.serialize.DataNumber;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.api.serialize.DataType;
import com.mrcrayfish.guns.cache.ObjectCache;
import com.mrcrayfish.guns.client.MetaLoader;
import com.mrcrayfish.guns.client.util.Easings;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.common.properties.SightAnimation;
import com.mrcrayfish.guns.item.IMeta;
import com.mrcrayfish.guns.item.attachment.IAttachment;
import com.mrcrayfish.guns.item.attachment.IBarrel;
import com.mrcrayfish.guns.item.attachment.IScope;
import com.mrcrayfish.guns.item.attachment.impl.Scope;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public final class PropertyHelper {
    public static final String CACHE_KEY = "properties";
    public static final String MODEL_KEY = "cgm:model";
    public static final String WEAPON_KEY = "cgm:weapon";
    public static final String SCOPE_KEY = "cgm:scope";
    public static final String BARREL_KEY = "cgm:barrel";
    public static final Vec3 GUN_DEFAULT_ORIGIN = new Vec3(8.0, 0.0, 8.0);
    public static final Vec3 ATTACHMENT_DEFAULT_ORIGIN = new Vec3(8.0, 8.0, 8.0);
    public static final Vec3 DEFAULT_SCALE = new Vec3(1.0, 1.0, 1.0);
    public static final Vec3 RED = new Vec3(255.0, 0.0, 0.0);

    public static void resetCache() {
        ObjectCache.getInstance(CACHE_KEY).reset();
    }

    private static DataObject getCustomData(ItemStack stack) {
        if (stack.m_41720_() instanceof IMeta) {
            return MetaLoader.getInstance().getData(stack.m_41720_());
        }
        return FrameworkClientAPI.getOpenModelData((ItemStack)stack, null, null, (int)0);
    }

    public static Vec3 getScopeCamera(ItemStack stack) {
        DataObject scopeObject;
        DataObject customObject = PropertyHelper.getCustomData(stack);
        if (customObject.has(SCOPE_KEY, DataType.OBJECT) && (scopeObject = customObject.getDataObject(SCOPE_KEY)).has("camera", DataType.ARRAY)) {
            DataArray cameraArray = scopeObject.getDataArray("camera");
            return PropertyHelper.arrayToVec3(cameraArray, Vec3.f_82478_);
        }
        Item cameraArray = stack.m_41720_();
        if (cameraArray instanceof IScope) {
            IScope scope = (IScope)cameraArray;
            Scope properties = (Scope)scope.getProperties();
            return new Vec3(0.0, properties.getReticleOffset(), properties.getViewFinderDistance() * 16.0).m_82549_(ATTACHMENT_DEFAULT_ORIGIN);
        }
        return ATTACHMENT_DEFAULT_ORIGIN;
    }

    public static Vec3 getIronSightCamera(ItemStack stack, Gun modifiedGun, Vec3 gunOrigin) {
        DataObject ironSightObject = PropertyHelper.getObjectByPath(stack, WEAPON_KEY, "ironSight");
        if (ironSightObject.has("camera", DataType.ARRAY)) {
            DataArray cameraArray = ironSightObject.getDataArray("camera");
            return PropertyHelper.arrayToVec3(cameraArray, Vec3.f_82478_);
        }
        Gun.Modules.Zoom zoom = modifiedGun.getModules().getZoom();
        if (zoom != null) {
            double cameraX = 8.0 - modifiedGun.getModules().getZoom().getXOffset();
            double cameraY = modifiedGun.getModules().getZoom().getYOffset();
            double cameraZ = 8.0 - modifiedGun.getModules().getZoom().getZOffset();
            return new Vec3(cameraX, cameraY, cameraZ);
        }
        return Vec3.f_82478_;
    }

    public static boolean isLegacyIronSight(ItemStack stack) {
        DataObject ironSightObject = PropertyHelper.getObjectByPath(stack, WEAPON_KEY, "ironSight");
        return !ironSightObject.has("camera", DataType.ARRAY);
    }

    public static Vec3 getModelOrigin(ItemStack stack, Vec3 defaultOrigin) {
        DataObject modelObject;
        DataObject customObject = PropertyHelper.getCustomData(stack);
        if (customObject.has(MODEL_KEY, DataType.OBJECT) && (modelObject = customObject.getDataObject(MODEL_KEY)).has("origin", DataType.ARRAY)) {
            DataArray originArray = modelObject.getDataArray("origin");
            return PropertyHelper.arrayToVec3(originArray, defaultOrigin);
        }
        return defaultOrigin;
    }

    public static Vec3 getAttachmentPosition(ItemStack stack, Gun modifiedGun, IAttachment.Type type) {
        DataObject scopeObject = PropertyHelper.getObjectByPath(stack, WEAPON_KEY, "attachments", type.getSerializeKey());
        if (scopeObject.has("translation", DataType.ARRAY)) {
            DataArray translationArray = scopeObject.getDataArray("translation");
            return PropertyHelper.arrayToVec3(translationArray, Vec3.f_82478_);
        }
        Gun.ScaledPositioned positioned = modifiedGun.getAttachmentPosition(type);
        if (positioned != null) {
            double displayX = positioned.getXOffset();
            double displayY = positioned.getYOffset();
            double displayZ = positioned.getZOffset();
            return new Vec3(displayX, displayY, displayZ).m_82549_(GUN_DEFAULT_ORIGIN);
        }
        return Vec3.f_82478_;
    }

    public static Vec3 getAttachmentScale(ItemStack weapon, Gun modifiedGun, IAttachment.Type type) {
        DataObject scopeObject = PropertyHelper.getObjectByPath(weapon, WEAPON_KEY, "attachments", type.getSerializeKey());
        if (scopeObject.has("scale", DataType.ARRAY)) {
            DataArray scaleArray = scopeObject.getDataArray("scale");
            return PropertyHelper.arrayToVec3(scaleArray, DEFAULT_SCALE);
        }
        Gun.ScaledPositioned positioned = modifiedGun.getAttachmentPosition(type);
        if (positioned != null) {
            return new Vec3(positioned.getScale(), positioned.getScale(), positioned.getScale());
        }
        return DEFAULT_SCALE;
    }

    public static boolean hasMuzzleFlash(ItemStack weapon, Gun modifiedGun) {
        DataObject weaponObject = PropertyHelper.getObjectByPath(weapon, WEAPON_KEY);
        return weaponObject.has("muzzleFlash", DataType.OBJECT) || modifiedGun.getDisplay().getFlash() != null;
    }

    public static Vec3 getMuzzleFlashPosition(ItemStack weapon, Gun modifiedGun) {
        DataObject barrelObject;
        ItemStack barrelStack;
        if (Gun.hasAttachmentEquipped(weapon, modifiedGun, IAttachment.Type.BARREL) && (barrelStack = Gun.getAttachment(IAttachment.Type.BARREL, weapon)).m_41720_() instanceof IBarrel && (barrelObject = PropertyHelper.getObjectByPath(barrelStack, BARREL_KEY)).has("muzzleFlash", DataType.OBJECT)) {
            DataObject muzzleObject = barrelObject.getDataObject("muzzleFlash");
            DataArray translationArray = muzzleObject.getDataArray("translation");
            Vec3 muzzlePosition = PropertyHelper.arrayToVec3(translationArray, Vec3.f_82478_);
            Vec3 barrelOrigin = PropertyHelper.getModelOrigin(barrelStack, ATTACHMENT_DEFAULT_ORIGIN);
            Vec3 barrelPosition = PropertyHelper.getAttachmentPosition(weapon, modifiedGun, IAttachment.Type.BARREL);
            Vec3 barrelScale = PropertyHelper.getAttachmentScale(weapon, modifiedGun, IAttachment.Type.BARREL);
            return muzzlePosition.m_82546_(barrelOrigin).m_82559_(barrelScale).m_82549_(barrelPosition);
        }
        DataObject weaponObject = PropertyHelper.getObjectByPath(weapon, WEAPON_KEY);
        if (weaponObject.has("muzzleFlash", DataType.OBJECT)) {
            DataObject muzzleObject = weaponObject.getDataObject("muzzleFlash");
            DataArray translationArray = muzzleObject.getDataArray("translation");
            return PropertyHelper.arrayToVec3(translationArray, Vec3.f_82478_);
        }
        Gun.Display.Flash muzzleFlash = modifiedGun.getDisplay().getFlash();
        if (muzzleFlash != null) {
            double displayX = muzzleFlash.getXOffset();
            double displayY = muzzleFlash.getYOffset();
            double displayZ = muzzleFlash.getZOffset();
            return new Vec3(displayX, displayY, displayZ).m_82549_(GUN_DEFAULT_ORIGIN);
        }
        return Vec3.f_82478_;
    }

    public static Vec3 getMuzzleFlashScale(ItemStack weapon, Gun modifiedGun) {
        DataObject weaponObject = PropertyHelper.getObjectByPath(weapon, WEAPON_KEY);
        if (weaponObject.has("muzzleFlash", DataType.OBJECT)) {
            DataObject muzzleObject = weaponObject.getDataObject("muzzleFlash");
            if (muzzleObject.has("scale", DataType.ARRAY)) {
                DataArray scaleArray = muzzleObject.getDataArray("scale");
                return PropertyHelper.arrayToVec3(scaleArray, DEFAULT_SCALE);
            }
            return DEFAULT_SCALE;
        }
        Gun.Display.Flash muzzleFlash = modifiedGun.getDisplay().getFlash();
        if (muzzleFlash != null) {
            double scale = muzzleFlash.getSize();
            return new Vec3(scale, scale, 1.0);
        }
        return DEFAULT_SCALE;
    }

    public static boolean isUsingBarrelMuzzleFlash(ItemStack barrel) {
        DataObject customObject = PropertyHelper.getObjectByPath(barrel, BARREL_KEY);
        return customObject.has("muzzleFlash", DataType.OBJECT);
    }

    public static int getReticleColor(ItemStack stack) {
        DataObject object;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("ReticleColor", 3)) {
            return tag.m_128451_("ReticleColor");
        }
        boolean isScope = stack.m_41720_() instanceof IScope;
        DataObject dataObject = object = isScope ? PropertyHelper.getObjectByPath(stack, SCOPE_KEY) : PropertyHelper.getObjectByPath(stack, WEAPON_KEY, "ironSight");
        if (object.has("reticleColor", DataType.NUMBER)) {
            return object.getDataNumber("reticleColor").asInt();
        }
        if (object.has("reticleColor", DataType.ARRAY)) {
            DataArray array = object.getDataArray("reticleColor");
            Vec3 color = PropertyHelper.arrayToVec3(array, RED);
            int a = 255;
            int r = Mth.m_14045_((int)((int)color.f_82479_), (int)0, (int)255);
            int g = Mth.m_14045_((int)((int)color.f_82480_), (int)0, (int)255);
            int b = Mth.m_14045_((int)((int)color.f_82481_), (int)0, (int)255);
            return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
        return -65536;
    }

    public static SightAnimation getSightAnimations(ItemStack weapon, Gun modifiedGun) {
        DataObject customObject;
        ItemStack scopeStack;
        Item item;
        if (Gun.hasAttachmentEquipped(weapon, modifiedGun, IAttachment.Type.SCOPE) && (item = (scopeStack = Gun.getScopeStack(weapon)).m_41720_()) instanceof IScope) {
            IScope scope = (IScope)item;
            DataObject scopeObject = PropertyHelper.getObjectByPath(scopeStack, SCOPE_KEY);
            DataEntry dataEntry = scopeObject.get("sightAnimation");
            if (dataEntry instanceof DataObject) {
                DataObject sightObject = (DataObject)dataEntry;
                return PropertyHelper.objectToSightAnimation(sightObject);
            }
        }
        if ((item = (customObject = PropertyHelper.getObjectByPath(weapon, WEAPON_KEY, "ironSight")).get("sightAnimation")) instanceof DataObject) {
            DataObject sightObject = (DataObject)item;
            return PropertyHelper.objectToSightAnimation(sightObject);
        }
        return SightAnimation.DEFAULT;
    }

    public static double getViewportFov(ItemStack weapon, Gun modifiedGun) {
        DataObject customObject;
        if (Gun.hasAttachmentEquipped(weapon, modifiedGun, IAttachment.Type.SCOPE)) {
            ItemStack scopeStack = Gun.getScopeStack(weapon);
            DataObject customObject2 = PropertyHelper.getObjectByPath(scopeStack, SCOPE_KEY);
            if (customObject2.has("viewportFov", DataType.NUMBER)) {
                return Mth.m_14008_((double)customObject2.getDataNumber("viewportFov").asDouble(), (double)1.0, (double)100.0);
            }
        }
        if ((customObject = PropertyHelper.getObjectByPath(weapon, WEAPON_KEY, "ironSight")).has("viewportFov", DataType.NUMBER)) {
            return Mth.m_14008_((double)customObject.getDataNumber("viewportFov").asDouble(), (double)1.0, (double)100.0);
        }
        return 0.0;
    }

    private static SightAnimation objectToSightAnimation(DataObject object) {
        ObjectCache cache = ObjectCache.getInstance(CACHE_KEY);
        Optional<SightAnimation> cachedValue = cache.get(object.getId());
        return cachedValue.orElseGet(() -> cache.store(object.getId(), () -> {
            SightAnimation.Builder builder = SightAnimation.builder();
            PropertyHelper.getOptionalString(object, "viewportCurve").ifPresent(s -> builder.setViewportCurve(Easings.byName(s)));
            PropertyHelper.getOptionalString(object, "sightCurve").ifPresent(s -> builder.setSightCurve(Easings.byName(s)));
            PropertyHelper.getOptionalString(object, "fovCurve").ifPresent(s -> builder.setFovCurve(Easings.byName(s)));
            PropertyHelper.getOptionalString(object, "aimTransformCurve").ifPresent(s -> builder.setAimTransformCurve(Easings.byName(s)));
            return builder.build();
        }));
    }

    private static Optional<String> getOptionalString(DataObject src, String key) {
        if (src.has(key, DataType.STRING)) {
            return Optional.ofNullable(src.getDataString(key).asString());
        }
        return Optional.empty();
    }

    private static DataObject getObjectByPath(ItemStack stack, String ... path) {
        DataObject result = PropertyHelper.getCustomData(stack);
        for (String key : path) {
            if (!result.has(key, DataType.OBJECT)) {
                return DataObject.EMPTY;
            }
            result = result.getDataObject(key);
        }
        return result;
    }

    private static Vec3 arrayToVec3(DataArray array, Vec3 defaultValue) {
        if (array.length() != 3) {
            return defaultValue;
        }
        ObjectCache cache = ObjectCache.getInstance(CACHE_KEY);
        Optional<Vec3> cachedValue = cache.get(array.getId());
        return cachedValue.orElseGet(() -> cache.store(array.getId(), () -> {
            if (array.values().stream().allMatch(entry -> entry.getType() == DataType.NUMBER)) {
                double x = ((DataNumber)array.get(0)).asDouble();
                double y = ((DataNumber)array.get(1)).asDouble();
                double z = ((DataNumber)array.get(2)).asDouble();
                return new Vec3(x, y, z);
            }
            return defaultValue;
        }));
    }
}

