/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.yabn.base;

import com.teamresourceful.resourcefullib.common.yabn.base.YabnElement;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnType;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.NullContents;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public record YabnObject(Map<String, YabnElement> elements) implements YabnElement
{
    public YabnObject() {
        this(new LinkedHashMap<String, YabnElement>());
    }

    public YabnObject put(String key, YabnElement element) {
        this.elements.put(key, element == null ? NullContents.NULL : element);
        return this;
    }

    public YabnElement get(String key) {
        return this.elements.get(key);
    }

    @Override
    public byte[] toData(@Nullable String key) {
        if (key == null) {
            return this.toData();
        }
        if (this.elements.isEmpty()) {
            return YabnElement.key(YabnType.EMPTY_OBJECT.id, key);
        }
        return ArrayUtils.addAll((byte[])YabnElement.key(YabnType.OBJECT.id, key), (byte[])this.internalData());
    }

    @Override
    public byte[] toData() {
        if (this.elements.isEmpty()) {
            return new byte[]{YabnType.EMPTY_OBJECT.id};
        }
        return ArrayUtils.addAll((byte[])new byte[]{YabnType.OBJECT.id}, (byte[])this.internalData());
    }

    private byte[] internalData() {
        byte[] data = new byte[]{};
        for (Map.Entry<String, YabnElement> entry : this.elements.entrySet()) {
            data = ArrayUtils.addAll((byte[])data, (byte[])entry.getValue().toData(entry.getKey()));
        }
        return ArrayUtils.addAll((byte[])data, (byte[])new byte[]{0});
    }
}

