/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import mcjty.lostcities.config.Configuration;
import mcjty.lostcities.gui.GuiLCConfig;
import mcjty.lostcities.gui.elements.GuiElement;
import mcjty.lostcities.varia.ComponentFactory;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class FloatElement
extends GuiElement {
    private final GuiLCConfig gui;
    private String label = null;
    private String prefix = null;
    private final EditBox field;
    private final String attribute;

    public FloatElement(final GuiLCConfig gui, String page, int x, int y, final String attribute) {
        super(page, x, y);
        this.gui = gui;
        this.attribute = attribute;
        Float c = gui.getLocalSetup().get().map(h -> (Float)h.toConfiguration().get(attribute)).orElse(Float.valueOf(0.0f));
        this.field = new EditBox(gui.getFont(), x, y, 45, 16, (Component)ComponentFactory.literal(Float.toString(c.floatValue()))){

            public void m_7428_(PoseStack stack, int x, int y) {
                gui.getLocalSetup().get().ifPresent(h -> gui.m_96602_(stack, h.toConfiguration().getValue(attribute).getComment(), x, y));
            }
        };
        this.field.m_94151_(s -> gui.getLocalSetup().get().ifPresent(profile -> {
            Configuration configuration = profile.toConfiguration();
            float value = 0.0f;
            try {
                value = Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                return;
            }
            Configuration.Value val = configuration.getValue(attribute);
            val.set(Float.valueOf(value));
            if (val.constrain()) {
                this.setValue(val.get());
            }
            profile.copyFromConfiguration(configuration);
            gui.refreshPreview();
        }));
        gui.addWidget(this.field);
    }

    public FloatElement prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public FloatElement label(String label) {
        this.label = label;
        return this;
    }

    @Override
    public void tick() {
        this.field.m_94120_();
    }

    @Override
    public void render(PoseStack stack) {
        if (this.field.f_93624_) {
            if (this.label != null) {
                GuiComponent.m_93236_((PoseStack)stack, (Font)this.gui.getFont(), (String)this.label, (int)10, (int)(this.y + 5), (int)-1);
            }
            if (this.prefix != null) {
                GuiComponent.m_93236_((PoseStack)stack, (Font)this.gui.getFont(), (String)this.prefix, (int)(this.x - 8), (int)(this.y + 5), (int)-1);
            }
        }
    }

    @Override
    public void update() {
        this.gui.getLocalSetup().get().ifPresent(profile -> {
            Object result = profile.toConfiguration().get(this.attribute);
            this.setValue(result);
        });
    }

    private void setValue(Object result) {
        if (result instanceof Float) {
            this.field.m_94144_(Float.toString(((Float)result).floatValue()));
        } else if (result instanceof Integer) {
            this.field.m_94144_(Integer.toString((Integer)result));
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.field.m_94186_(b);
    }

    @Override
    public void setBasedOnMode(String mode) {
        this.field.m_94194_(this.page.equalsIgnoreCase(mode));
    }
}

