/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.config.ProfileSetup;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.MultiPackResourceManager;

public class LostCitySetup {
    public static final LostCitySetup CLIENT_SETUP = new LostCitySetup(() -> {});
    private List<String> profiles = null;
    private String profile = null;
    private LostCityProfile customizedProfile = null;
    private final Runnable refreshPreview;

    public LostCitySetup(Runnable refreshPreview) {
        this.refreshPreview = refreshPreview;
    }

    public LostCityProfile getCustomizedProfile() {
        return this.customizedProfile;
    }

    public void reset() {
        this.profiles = null;
        this.profile = null;
        this.customizedProfile = null;
    }

    public boolean isCustomizable() {
        if (this.profile == null) {
            return false;
        }
        return !"customized".equals(this.profile);
    }

    public String getProfile() {
        return this.profile;
    }

    public String getProfileLabel() {
        return this.profile == null ? "Disabled" : this.profile;
    }

    public String getWorldStyleLabel() {
        return this.get().isEmpty() ? "n.a." : this.get().get().getWorldStyle();
    }

    public void setProfile(String profile) {
        this.profile = profile;
        this.refreshPreview.run();
    }

    public void copyFrom(LostCitySetup other) {
        this.profile = other.profile;
        this.customizedProfile = other.customizedProfile;
    }

    public void customize() {
        if (this.profile == null) {
            throw new IllegalStateException("Cannot happen!");
        }
        this.customizedProfile = new LostCityProfile("customized", false);
        LostCityProfile original = ProfileSetup.STANDARD_PROFILES.get(this.profile);
        ProfileSetup.STANDARD_PROFILES.put("customized", this.customizedProfile);
        this.profiles.add("customized");
        this.customizedProfile.copyFrom(original);
        this.profile = "customized";
        this.refreshPreview.run();
    }

    public Optional<LostCityProfile> get() {
        if (this.profile == null) {
            return Optional.empty();
        }
        if ("customized".equals(this.profile)) {
            return Optional.ofNullable(this.customizedProfile);
        }
        return Optional.of(ProfileSetup.STANDARD_PROFILES.get(this.profile));
    }

    private static String worldStyleToName(ResourceLocation rl) {
        Object path = rl.m_135815_();
        int idx = ((String)path).lastIndexOf(47);
        if (idx != -1) {
            path = ((String)path).substring(idx + 1);
        }
        if ((idx = ((String)path).lastIndexOf(46)) != -1) {
            path = ((String)path).substring(0, idx);
        }
        if (!"lostcities".equals(rl.m_135827_())) {
            path = rl.m_135827_() + ":" + (String)path;
        }
        return path;
    }

    public void toggleWorldStyle() {
        String current;
        PackRepository repository = Minecraft.m_91087_().m_91099_();
        MultiPackResourceManager resourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, repository.m_10525_());
        Map map = resourceManager.m_214159_("lostcities/worldstyles", s -> s.toString().endsWith(".json"));
        List styles = map.keySet().stream().map(LostCitySetup::worldStyleToName).collect(Collectors.toList());
        int idx = styles.indexOf(current = this.get().map(LostCityProfile::getWorldStyle).orElse("<none>"));
        if (idx == -1) {
            idx = 0;
        } else if (++idx >= styles.size()) {
            idx = 0;
        }
        if (this.get().isPresent()) {
            this.get().get().setWorldStyle((String)styles.get(idx));
        }
        this.refreshPreview.run();
    }

    public void toggleProfile() {
        int i;
        if (this.profiles == null) {
            String preferedProfile = "default";
            this.profiles = ProfileSetup.STANDARD_PROFILES.entrySet().stream().filter(entry -> ((LostCityProfile)entry.getValue()).isPublic()).map(Map.Entry::getKey).collect(Collectors.toList());
            this.profiles.sort((o1, o2) -> {
                if (preferedProfile.equals(o1)) {
                    return -1;
                }
                if (preferedProfile.equals(o2)) {
                    return 1;
                }
                return o1.compareTo((String)o2);
            });
        }
        this.profile = this.profile == null ? this.profiles.get(0) : ((i = this.profiles.indexOf(this.profile)) == -1 || i >= this.profiles.size() - 1 ? null : this.profiles.get(i + 1));
        this.refreshPreview.run();
    }
}

