/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.loaders;

import java.io.File;
import java.nio.file.Path;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.core.exceptions.IllegalEnvironmentException;
import me.srrapero720.watermedia.core.exceptions.IllegalTLauncherException;
import me.srrapero720.watermedia.core.tools.Tool;
import me.srrapero720.watermedia.loaders.ILoader;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;

@Mod(value="watermedia")
public class NeoForgeLoader
implements ILoader {
    private static final Path tmpPath = new File(System.getProperty("java.io.tmpdir")).toPath().toAbsolutePath().resolve("watermedia");

    public NeoForgeLoader() {
        try {
            if (this.tlcheck()) {
                throw new IllegalTLauncherException();
            }
            if (!this.clientSide()) {
                throw new IllegalEnvironmentException();
            }
            WaterMedia.prepare(this).start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed starting WATERMeDIA for " + this.name() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public String name() {
        return "NeoForge";
    }

    @Override
    public Path tempDir() {
        return tmpPath;
    }

    @Override
    public Path processDir() {
        return FMLLoader.getGamePath();
    }

    @Override
    public boolean tlcheck() {
        boolean tllike = Tool.t();
        if (!tllike) {
            try {
                ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
                Class<?> launcher = Class.forName("cpw.mods.modlauncher.Launcher");
                Thread.currentThread().setContextClassLoader(launcher.getClassLoader());
                tllike = Tool.t();
                Thread.currentThread().setContextClassLoader(currentCL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tllike;
    }

    @Override
    public boolean clientSide() {
        return FMLLoader.getDist().isClient();
    }

    @Override
    public boolean developerMode() {
        return FMLLoader.isProduction();
    }
}

