/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.core.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.lib720.apache.compress.archivers.sevenz.SevenZArchiveEntry;
import me.lib720.apache.compress.archivers.sevenz.SevenZFile;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.image.decoders.GifDecoder;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class IOTool {
    private static final Marker IT = MarkerManager.getMarker((String)"Tools");

    public static String readString(Path from) {
        try {
            byte[] bytes = Files.readAllBytes(from);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GifDecoder readGif(Path path) {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path.toFile().toPath(), new OpenOption[0]));){
            GifDecoder gif = new GifDecoder();
            int status = gif.read(in);
            if (status != 0) throw new IOException("Failed to process GIF - Decoder status: " + status);
            GifDecoder gifDecoder = gif;
            return gifDecoder;
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Failed loading GIF from WaterMedia resources", (Throwable)e);
            return null;
        }
    }

    public static void un7zip(Marker it, Path zipFilePath) throws IOException {
        IOTool.un7zip(it, zipFilePath, zipFilePath.getParent());
    }

    public static void un7zip(Marker it, Path zipFilePath, Path destDirectory) throws IOException {
        WaterMedia.LOGGER.debug(it, "Un7zipping file from '{}' to directory '{}'", (Object)zipFilePath, (Object)destDirectory);
        if (zipFilePath.toString().endsWith(".zip")) {
            throw new IOException("Attempted to extract a .zip as a .7z");
        }
        File destDir = destDirectory.toFile();
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        try (SevenZFile sevenZFile = new SevenZFile(zipFilePath.toFile());){
            SevenZArchiveEntry entry = sevenZFile.getNextEntry();
            while (entry != null) {
                File outputFile = new File(destDirectory + File.separator + entry.getName());
                if (!outputFile.exists()) {
                    if (entry.isDirectory()) {
                        if (!outputFile.mkdirs()) {
                            WaterMedia.LOGGER.error(IT, "Cannot create directories of '{}'", (Object)entry.getName());
                        }
                    } else {
                        IOTool.un7zip$extract(sevenZFile, outputFile.toPath());
                    }
                } else {
                    WaterMedia.LOGGER.warn(it, "Cancelled un7zip attempt of '{}', file already exists", (Object)entry.getName());
                }
                entry = sevenZFile.getNextEntry();
            }
        }
    }

    private static void un7zip$extract(SevenZFile sevenZFile, Path filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));){
            int read;
            byte[] content = new byte[16384];
            while ((read = sevenZFile.read(content)) != -1) {
                bos.write(content, 0, read);
            }
        }
    }

    public static void unzip(Marker it, Path zipFilePath) throws IOException {
        IOTool.unzip(it, zipFilePath, zipFilePath.getParent());
    }

    public static void unzip(Marker it, Path zipFilePath, Path destDirectory) throws IOException {
        WaterMedia.LOGGER.debug(it, "Unzipping file from '{}' to directory '{}'", (Object)zipFilePath, (Object)destDirectory);
        if (zipFilePath.toString().endsWith(".7z")) {
            throw new IOException("Attempted to extract a 7z as a .zip");
        }
        File destDir = destDirectory.toFile();
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String filePath = destDirectory + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    IOTool.unzip$extract(zipIn, filePath);
                } else {
                    File dir = new File(filePath);
                    dir.mkdirs();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    private static void unzip$extract(ZipInputStream zipIn, String filePath) throws IOException {
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));){
            int read;
            byte[] bytesIn = new byte[4096];
            while ((read = zipIn.read(bytesIn)) != -1) {
                output.write(bytesIn, 0, read);
            }
        }
    }
}

