/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.fixers;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import me.srrapero720.watermedia.api.network.streamable.SAVideo;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;

public class StreamableFixer
extends URLFixer {
    private static final String API_URL = "https://api.streamable.com/videos/";
    private static final Gson GSON = new Gson();

    @Override
    public String platform() {
        return "Streamable";
    }

    @Override
    public boolean isValid(URL url) {
        return url.getHost().equals("streamable.com");
    }

    @Override
    public URLFixer.Result patch(URL url, URLFixer.Quality prefQuality) throws URLFixer.FixingURLException {
        URLFixer.Result result;
        String videoId = url.getPath().substring(1);
        HttpURLConnection connection = (HttpURLConnection)new URL(API_URL + videoId).openConnection();
        if (connection.getResponseCode() == 404) {
            throw new NullPointerException("Video doesn't exists");
        }
        InputStreamReader is = new InputStreamReader(connection.getInputStream());
        try {
            SAVideo video = (SAVideo)GSON.fromJson((Reader)is, SAVideo.class);
            result = new URLFixer.Result(new URL(video.files.mp4.url), true, false);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new URLFixer.FixingURLException(url, (Throwable)e);
            }
        }
        is.close();
        return result;
    }
}

