/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;
import me.srrapero720.watermedia.api.url.fixers.special.SpecialFixer;
import me.srrapero720.watermedia.core.tools.DataTool;
import me.srrapero720.watermedia.loaders.ILoader;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class UrlAPI
extends WaterMediaAPI {
    public static final Marker IT = MarkerManager.getMarker((String)"UrlAPI");
    private static final List<URLFixer> FIXERS = new ArrayList<URLFixer>();

    public static URLFixer.Result fixURL(String strUrl) {
        return UrlAPI.fixURL(strUrl, true);
    }

    public static URLFixer.Result fixURL(String strUrl, boolean specials) {
        try {
            if (strUrl.startsWith("local://")) {
                if ((strUrl = strUrl.substring("local://".length())).startsWith("/")) {
                    strUrl = strUrl.substring(1);
                }
                URL url = new File(strUrl).toURI().toURL();
                WaterMedia.LOGGER.debug(IT, "Fixed protocol 'local://' to '{}'", (Object)url.toString());
                return new URLFixer.Result(url, false, false);
            }
            URL url = new URL(strUrl);
            if (strUrl.startsWith("file:///")) {
                return new URLFixer.Result(url, false, false);
            }
            for (URLFixer fixer : FIXERS) {
                if (!fixer.isValid(url)) continue;
                return fixer.patch(url, null);
            }
            return new URLFixer.Result(url, false, false);
        }
        catch (Exception e) {
            WaterMedia.LOGGER.error(IT, "Exception occurred fixing URL", (Throwable)e);
            return null;
        }
    }

    public static String[] getFixersPlatforms() {
        return UrlAPI.getFixersPlatforms(false);
    }

    public static String[] getFixersPlatforms(boolean specials) {
        String[] result = new String[FIXERS.size()];
        for (int i = 0; i < FIXERS.size(); ++i) {
            URLFixer fixer = FIXERS.get(i);
            if (fixer instanceof SpecialFixer && !specials) continue;
            result[i] = fixer.platform();
        }
        return result;
    }

    public static boolean isValid(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean isValidPathUrl(String path) {
        try {
            new File(path).toURI().toURL();
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static Map<String, String> parseQuery(String query) {
        String[] params;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (String param : params = query.split("&")) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            queryParams.put(key, value);
        }
        return queryParams;
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.NORMAL;
    }

    @Override
    public boolean prepare(ILoader bootCore) throws Exception {
        return FIXERS.isEmpty();
    }

    @Override
    public void start(ILoader bootCore) throws Exception {
        FIXERS.addAll(DataTool.toList(ServiceLoader.load(URLFixer.class)));
    }

    @Override
    public void release() {
    }
}

