/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.support.eventmanager;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class TaskExecutor {
    private static final long DEFAULT_TIMEOUT = 5000L;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public void submit(Runnable r) {
        this.executor.submit(r);
    }

    public void release() {
        this.shutdownExecutor(5000L);
    }

    public void release(long timeout) {
        this.shutdownExecutor(timeout);
    }

    private void shutdownExecutor(long timeout) {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                this.executor.shutdownNow();
                this.executor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }
}

