/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.discovery.provider;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import me.lib720.caprica.vlcj.discovery.NativeDiscovery;
import me.lib720.caprica.vlcj.discovery.provider.DiscoveryDirectoryProvider;

public class WindowsInstallDirectoryProvider
implements DiscoveryDirectoryProvider {
    private static final String VLC_REGISTRY_KEY = "SOFTWARE\\VideoLAN\\VLC";
    private static final String VLC_INSTALL_DIR_KEY = "InstallDir";

    @Override
    public int priority() {
        return -3;
    }

    @Override
    public String[] directories() {
        String installDir = this.getVlcInstallDir();
        String userInstallDir = this.getVlcUserInstallDir();
        if (installDir != null && userInstallDir != null) {
            return new String[]{installDir, userInstallDir};
        }
        if (installDir != null) {
            return new String[]{installDir};
        }
        if (userInstallDir != null) {
            return new String[]{userInstallDir};
        }
        return new String[0];
    }

    @Override
    public boolean supported() {
        return Platform.isWindows();
    }

    private String getVlcInstallDir() {
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)VLC_REGISTRY_KEY, (String)VLC_INSTALL_DIR_KEY);
        }
        catch (Exception e) {
            NativeDiscovery.LOGGER.error("Failed to get VLC installation path from HKEY_LOCAL_MACHINE: {}", (Object)e.getMessage());
            NativeDiscovery.LOGGER.warn("Recurring to fallback system...");
            if (new File("C:\\Program Files\\VideoLAN\\VLC").exists()) {
                NativeDiscovery.LOGGER.info("VLC well-know installation folder founded.");
                return "C:\\Program Files\\VideoLAN\\VLC";
            }
            if (new File("C:\\Program Files (x86)\\VideoLAN\\VLC").exists()) {
                NativeDiscovery.LOGGER.info("VLC well-know installation folder founded.");
                NativeDiscovery.LOGGER.warn("DEPRECATION NOTICE: x32 is not longer supported. Please switch to an x64 installation");
                return "C:\\Program Files (x86)\\VideoLAN\\VLC";
            }
            NativeDiscovery.LOGGER.warn("Fallback system failed... delegating decision to NativeDiscovery");
            return null;
        }
    }

    private String getVlcUserInstallDir() {
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)VLC_REGISTRY_KEY, (String)VLC_INSTALL_DIR_KEY);
        }
        catch (Exception e) {
            return null;
        }
    }
}

