/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.everythingcopper;

import cy.jdkdigital.everythingcopper.common.entity.CopperGolem;
import cy.jdkdigital.everythingcopper.event.EventHandler;
import cy.jdkdigital.everythingcopper.init.ModBlockEntities;
import cy.jdkdigital.everythingcopper.init.ModBlocks;
import cy.jdkdigital.everythingcopper.init.ModEffects;
import cy.jdkdigital.everythingcopper.init.ModEntities;
import cy.jdkdigital.everythingcopper.init.ModItems;
import cy.jdkdigital.everythingcopper.init.ModLootModifiers;
import cy.jdkdigital.everythingcopper.init.ModRecipeTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="everythingcopper")
public class EverythingCopper {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "everythingcopper";

    public EverythingCopper() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModEffects.EFFECTS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModLootModifiers.LOOT_SERIALIZERS.register(modEventBus);
        ModRecipeTypes.RECIPE_SERIALIZERS.register(modEventBus);
        modEventBus.addListener(EventHandler::onEntityAttributeCreate);
        modEventBus.addListener(this::onCommonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        DispenserBlock.m_52672_((ItemLike)Items.f_42047_, (DispenseItemBehavior)new CopperGolemDispenserBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_42055_, (DispenseItemBehavior)new CopperGolemDispenserBehavior());
    }

    public void onServerStarting(AddReloadListenerEvent event) {
    }

    static class CopperGolemDispenserBehavior
    extends OptionalDispenseItemBehavior {
        CopperGolemDispenserBehavior() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            Item item;
            ServerLevel level = source.m_7727_();
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos blockpos = source.m_7961_().m_121945_(direction);
            CarvedPumpkinBlock carvedpumpkinblock = (CarvedPumpkinBlock)Blocks.f_50143_;
            if (level.m_46859_(blockpos) && (item = stack.m_41720_()) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (carvedpumpkinblock.m_51381_((LevelReader)level, blockpos) || CopperGolem.canSpawnGolem((LevelReader)level, blockpos)) {
                    if (!level.f_46443_) {
                        level.m_7731_(blockpos, blockItem.m_40614_().m_49966_(), 3);
                        level.m_142346_(null, GameEvent.f_157797_, blockpos);
                        ForgeEventFactory.onBlockPlace(null, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)blockpos), (Direction)direction);
                    }
                    stack.m_41774_(1);
                    this.m_123573_(true);
                    return stack;
                }
            }
            this.m_123573_(ArmorItem.m_40398_((BlockSource)source, (ItemStack)stack));
            return stack;
        }
    }
}

