/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.util.RegistryHelper;

public class WoodBlockObject
extends FenceBuildingBlockObject {
    private final WoodType woodType;
    private final Supplier<? extends Block> log;
    private final Supplier<? extends Block> strippedLog;
    private final Supplier<? extends Block> wood;
    private final Supplier<? extends Block> strippedWood;
    private final Supplier<? extends FenceGateBlock> fenceGate;
    private final Supplier<? extends DoorBlock> door;
    private final Supplier<? extends TrapDoorBlock> trapdoor;
    private final Supplier<? extends PressurePlateBlock> pressurePlate;
    private final Supplier<? extends WoodButtonBlock> button;
    private final Supplier<? extends StandingSignBlock> sign;
    private final Supplier<? extends WallSignBlock> wallSign;
    private final TagKey<Block> logBlockTag;
    private final TagKey<Item> logItemTag;

    public WoodBlockObject(ResourceLocation name, WoodType woodType, BuildingBlockObject planks, Supplier<? extends Block> log, Supplier<? extends Block> strippedLog, Supplier<? extends Block> wood, Supplier<? extends Block> strippedWood, Supplier<? extends FenceBlock> fence, Supplier<? extends FenceGateBlock> fenceGate, Supplier<? extends DoorBlock> door, Supplier<? extends TrapDoorBlock> trapdoor, Supplier<? extends PressurePlateBlock> pressurePlate, Supplier<? extends WoodButtonBlock> button, Supplier<? extends StandingSignBlock> sign, Supplier<? extends WallSignBlock> wallSign) {
        super(planks, fence);
        this.woodType = woodType;
        this.log = log;
        this.strippedLog = strippedLog;
        this.wood = wood;
        this.strippedWood = strippedWood;
        this.fenceGate = fenceGate;
        this.door = door;
        this.trapdoor = trapdoor;
        this.pressurePlate = pressurePlate;
        this.button = button;
        this.sign = sign;
        this.wallSign = wallSign;
        ResourceLocation tagName = new ResourceLocation(name.m_135827_(), name.m_135815_() + "_logs");
        this.logBlockTag = BlockTags.create((ResourceLocation)tagName);
        this.logItemTag = ItemTags.create((ResourceLocation)tagName);
    }

    public WoodBlockObject(ResourceLocation name, WoodType woodType, BuildingBlockObject planks, Block log, Block strippedLog, Block wood, Block strippedWood, Block fence, Block fenceGate, Block door, Block trapdoor, Block pressurePlate, Block button, Block sign, Block wallSign) {
        super(planks, fence);
        this.woodType = woodType;
        this.log = RegistryHelper.getHolder(Registry.f_122824_, log);
        this.strippedLog = RegistryHelper.getHolder(Registry.f_122824_, strippedLog);
        this.wood = RegistryHelper.getHolder(Registry.f_122824_, wood);
        this.strippedWood = RegistryHelper.getHolder(Registry.f_122824_, strippedWood);
        this.fenceGate = RegistrationHelper.getCastedHolder(Registry.f_122824_, fenceGate);
        this.door = RegistrationHelper.getCastedHolder(Registry.f_122824_, door);
        this.trapdoor = RegistrationHelper.getCastedHolder(Registry.f_122824_, trapdoor);
        this.pressurePlate = RegistrationHelper.getCastedHolder(Registry.f_122824_, pressurePlate);
        this.button = RegistrationHelper.getCastedHolder(Registry.f_122824_, button);
        this.sign = RegistrationHelper.getCastedHolder(Registry.f_122824_, sign);
        this.wallSign = RegistrationHelper.getCastedHolder(Registry.f_122824_, wallSign);
        ResourceLocation tagName = new ResourceLocation(name.m_135827_(), name.m_135815_() + "_logs");
        this.logBlockTag = BlockTags.create((ResourceLocation)tagName);
        this.logItemTag = ItemTags.create((ResourceLocation)tagName);
    }

    public Block getLog() {
        return this.log.get();
    }

    public Block getStrippedLog() {
        return this.strippedLog.get();
    }

    public Block getWood() {
        return this.wood.get();
    }

    public Block getStrippedWood() {
        return this.strippedWood.get();
    }

    public FenceGateBlock getFenceGate() {
        return this.fenceGate.get();
    }

    public DoorBlock getDoor() {
        return this.door.get();
    }

    public TrapDoorBlock getTrapdoor() {
        return this.trapdoor.get();
    }

    public PressurePlateBlock getPressurePlate() {
        return this.pressurePlate.get();
    }

    public WoodButtonBlock getButton() {
        return this.button.get();
    }

    public StandingSignBlock getSign() {
        return this.sign.get();
    }

    public WallSignBlock getWallSign() {
        return this.wallSign.get();
    }

    @Override
    public List<Block> values() {
        return Arrays.asList((Block)this.get(), this.getSlab(), this.getStairs(), this.getFence(), this.getLog(), this.getStrippedLog(), this.getWood(), this.getStrippedWood(), this.getFenceGate(), this.getDoor(), this.getTrapdoor(), this.getPressurePlate(), this.getButton(), this.getSign(), this.getWallSign());
    }

    @Override
    public void forEach(Consumer<ItemLike> consumer) {
        super.forEach(consumer);
        consumer.accept((ItemLike)this.getFenceGate());
        consumer.accept((ItemLike)this.getLog());
        consumer.accept((ItemLike)this.getStrippedLog());
        consumer.accept((ItemLike)this.getWood());
        consumer.accept((ItemLike)this.getStrippedWood());
        consumer.accept((ItemLike)this.getDoor());
        consumer.accept((ItemLike)this.getTrapdoor());
        consumer.accept((ItemLike)this.getPressurePlate());
        consumer.accept((ItemLike)this.getButton());
        consumer.accept((ItemLike)this.getSign());
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public TagKey<Block> getLogBlockTag() {
        return this.logBlockTag;
    }

    public TagKey<Item> getLogItemTag() {
        return this.logItemTag;
    }

    public static enum WoodVariant {
        LOG,
        WOOD,
        PLANKS;

    }
}

