/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.util.RetexturedHelper;

public class RetexturedBlockItem
extends BlockTooltipItem {
    protected final TagKey<Item> textureTag;

    public RetexturedBlockItem(Block block, TagKey<Item> textureTag, Item.Properties builder) {
        super(block, builder);
        this.textureTag = textureTag;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            RetexturedBlockItem.addTagVariants((ItemLike)this.m_40614_(), this.textureTag, items, true);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        RetexturedBlockItem.addTooltip(stack, tooltip);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static String getTextureName(ItemStack stack) {
        return RetexturedHelper.getTextureName(stack.m_41783_());
    }

    public static Block getTexture(ItemStack stack) {
        return RetexturedHelper.getBlock(RetexturedBlockItem.getTextureName(stack));
    }

    public static void addTooltip(ItemStack stack, List<Component> tooltip) {
        Block block = RetexturedBlockItem.getTexture(stack);
        if (block != Blocks.f_50016_) {
            tooltip.add((Component)block.m_49954_());
        }
    }

    public static ItemStack setTexture(ItemStack stack, String name) {
        if (!name.isEmpty()) {
            RetexturedHelper.setTexture(stack.m_41784_(), name);
        } else if (stack.m_41782_()) {
            RetexturedHelper.setTexture(stack.m_41783_(), name);
        }
        return stack;
    }

    public static ItemStack setTexture(ItemStack stack, @Nullable Block block) {
        if (block == null || block == Blocks.f_50016_) {
            return RetexturedBlockItem.setTexture(stack, "");
        }
        return RetexturedBlockItem.setTexture(stack, Registry.f_122824_.m_7981_((Object)block).toString());
    }

    public static void addTagVariants(ItemLike block, TagKey<Item> tag, NonNullList<ItemStack> list, boolean showAllVariants) {
        boolean added = false;
        Class<?> clazz = block.getClass();
        for (Holder candidate : Registry.f_122827_.m_206058_(tag)) {
            Block textureBlock;
            Item item;
            if (!candidate.m_203633_() || !((item = (Item)candidate.m_203334_()) instanceof BlockItem) || clazz.isInstance(textureBlock = ((BlockItem)item).m_40614_())) continue;
            added = true;
            list.add((Object)RetexturedBlockItem.setTexture(new ItemStack(block), textureBlock));
            if (showAllVariants) continue;
            return;
        }
        if (!added) {
            list.add((Object)new ItemStack(block));
        }
    }
}

