/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.AlwaysPresentLoadableField;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;

public record MergingRegistryField<T extends GenericLoaderRegistry.IHaveLoader, P>(Loadable<T> loadable, String typeKey, Function<P, T> getter) implements AlwaysPresentLoadableField<T, P>
{
    public static void mapType(JsonObject json, String typeKey) {
        json.addProperty("type", GsonHelper.m_13906_((JsonObject)json, (String)typeKey));
        json.remove(typeKey);
    }

    public static <N extends GenericLoaderRegistry.IHaveLoader> void serializeInto(JsonObject json, String typeKey, Loadable<N> loader, N value) {
        JsonElement element = loader.serialize(value);
        if (element.isJsonObject()) {
            JsonObject nestedObject = element.getAsJsonObject();
            for (Map.Entry entry : nestedObject.entrySet()) {
                String key = (String)entry.getKey();
                if (typeKey.equals(key)) {
                    throw new JsonIOException("Unable to serialize nested object, object already has key " + typeKey);
                }
                if ("type".equals(key)) {
                    key = typeKey;
                }
                json.add(key, (JsonElement)entry.getValue());
            }
        } else if (element.isJsonPrimitive()) {
            json.add(typeKey, element);
        } else {
            throw new JsonIOException("Unable to serialize nested object, expected string or object");
        }
    }

    @Override
    public T get(JsonObject json) {
        MergingRegistryField.mapType(json, this.typeKey);
        return (T)((GenericLoaderRegistry.IHaveLoader)this.loadable.convert((JsonElement)json, "[unknown]"));
    }

    @Override
    public void serialize(P parent, JsonObject json) {
        MergingRegistryField.serializeInto(json, this.typeKey, this.loadable, (GenericLoaderRegistry.IHaveLoader)this.getter.apply(parent));
    }
}

