/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.primitive;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;

public enum BooleanLoadable implements StringLoadable<Boolean>
{
    INSTANCE;


    @Override
    public Boolean convert(JsonElement element, String key) {
        return GsonHelper.m_13877_((JsonElement)element, (String)key);
    }

    @Override
    public JsonElement serialize(Boolean object) {
        return new JsonPrimitive(object);
    }

    @Override
    public Boolean decode(FriendlyByteBuf buffer) {
        return buffer.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buffer, Boolean object) {
        buffer.writeBoolean(object.booleanValue());
    }

    @Override
    public <P> LoadableField<Boolean, P> defaultField(String key, Boolean defaultValue, Function<P, Boolean> getter) {
        return this.defaultField(key, defaultValue, true, getter);
    }

    @Override
    public Boolean parseString(String value, String key) {
        return switch (value.toLowerCase(Locale.ROOT)) {
            case "true" -> true;
            case "false" -> false;
            default -> throw new JsonSyntaxException("Invalid boolean '" + value + "'");
        };
    }

    @Override
    public String getString(Boolean object) {
        return object.toString();
    }
}

