/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.mapping.MapLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;

public class EnumMapLoadable<K extends Enum<K>, V>
extends MapLoadable<K, V> {
    private final Class<K> enumClass;

    public EnumMapLoadable(Class<K> enumClass, StringLoadable<K> keyLoadable, Loadable<V> valueLoadable, int minSize) {
        super(keyLoadable, valueLoadable, minSize);
        this.enumClass = enumClass;
    }

    public EnumMapLoadable(EnumLoadable<K> keyLoadable, Loadable<V> valueLoadable, int minSize) {
        this(keyLoadable.enumClass(), keyLoadable, valueLoadable, minSize);
    }

    @Override
    public Map<K, V> convert(JsonElement element, String key) {
        JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)key);
        if (json.size() < this.minSize) {
            throw new JsonSyntaxException(key + " must have at least " + this.minSize + " elements");
        }
        EnumMap map = new EnumMap(this.enumClass);
        String mapKey = key + "'s key";
        for (Map.Entry entry : json.entrySet()) {
            String entryKey = (String)entry.getKey();
            map.put((Enum)this.keyLoadable.parseString(entryKey, mapKey), this.valueLoadable.convert((JsonElement)entry.getValue(), entryKey));
        }
        return map;
    }

    @Override
    public Map<K, V> decode(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        EnumMap<Enum, Object> map = new EnumMap<Enum, Object>(this.enumClass);
        for (int i = 0; i < size; ++i) {
            map.put((Enum)this.keyLoadable.decode(buffer), this.valueLoadable.decode(buffer));
        }
        return map;
    }
}

