/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.field;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Function;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.AlwaysPresentLoadableField;

public record TryDirectField<T, P>(Loadable<T> loadable, String key, Function<P, T> getter, String[] conflicts) implements AlwaysPresentLoadableField<T, P>
{
    @Override
    public T get(JsonObject json) {
        if (json.has(this.key)) {
            return this.loadable.convert(json.get(this.key), this.key);
        }
        return this.loadable.convert((JsonElement)json, this.key);
    }

    private boolean hasConflict(JsonObject parent, JsonObject serialized) {
        if (serialized.has(this.key)) {
            return true;
        }
        for (String conflict : parent.keySet()) {
            if (!serialized.has(conflict)) continue;
            return true;
        }
        for (String conflict : this.conflicts) {
            if (!serialized.has(conflict)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void serialize(P parent, JsonObject json) {
        JsonObject serialized;
        JsonElement element = this.loadable.serialize(this.getter.apply(parent));
        if (element.isJsonObject() && !this.hasConflict(json, serialized = element.getAsJsonObject())) {
            for (Map.Entry entry : serialized.entrySet()) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            return;
        }
        json.add(this.key, element);
    }
}

