/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.model.data.ModelData;
import slimeknights.mantle.client.book.structure.StructureInfo;
import slimeknights.mantle.client.book.structure.level.TemplateLevel;
import slimeknights.mantle.client.render.MantleRenderTypes;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class StructureElement
extends SizedBookElement {
    public boolean canTick = false;
    public float scale = 50.0f;
    public float transX = 0.0f;
    public float transY = 0.0f;
    public Transformation additionalTransform;
    public final StructureInfo renderInfo;
    public final TemplateLevel structureWorld;
    public long lastStep = -1L;
    public long lastPrintedErrorTimeMs = -1L;

    public StructureElement(int x, int y, int width, int height, StructureTemplate template, List<StructureTemplate.StructureBlockInfo> structure) {
        super(x, y, width, height);
        int[] size = new int[]{template.m_163801_().m_123341_(), template.m_163801_().m_123342_(), template.m_163801_().m_123343_()};
        this.scale = 100.0f / (float)IntStream.of(size).max().getAsInt();
        float sx = (float)width / 182.0f;
        float sy = (float)height / 176.0f;
        this.scale *= Math.min(sx, sy);
        this.renderInfo = new StructureInfo(structure);
        this.structureWorld = new TemplateLevel(structure, this.renderInfo);
        this.transX = (float)x + (float)width / 2.0f;
        this.transY = (float)y + (float)height / 2.0f;
        this.additionalTransform = new Transformation(null, new Quaternion(25.0f, 0.0f, 0.0f, true), null, new Quaternion(0.0f, -45.0f, 0.0f, true));
    }

    @Override
    public void draw(PoseStack transform, int mouseX, int mouseY, float partialTicks, Font fontRenderer) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        PoseStack.Pose lastEntryBeforeTry = transform.m_85850_();
        try {
            long currentTime = System.currentTimeMillis();
            if (this.lastStep < 0L) {
                this.lastStep = currentTime;
            } else if (this.canTick && currentTime - this.lastStep > 200L) {
                this.renderInfo.step();
                this.lastStep = currentTime;
            }
            if (!this.canTick) {
                this.renderInfo.reset();
            }
            int structureLength = this.renderInfo.structureLength;
            int structureWidth = this.renderInfo.structureWidth;
            int structureHeight = this.renderInfo.structureHeight;
            transform.m_85836_();
            BlockRenderDispatcher blockRender = Minecraft.m_91087_().m_91289_();
            transform.m_85837_((double)this.transX, (double)this.transY, (double)Math.max(structureHeight, Math.max(structureWidth, structureLength)));
            transform.m_85841_(this.scale, -this.scale, 1.0f);
            this.additionalTransform.push(transform);
            transform.m_85845_(new Quaternion(0.0f, 0.0f, 0.0f, true));
            transform.m_85837_((double)((float)structureLength / -2.0f), (double)((float)structureHeight / -2.0f), (double)((float)structureWidth / -2.0f));
            for (int h = 0; h < structureHeight; ++h) {
                for (int l = 0; l < structureLength; ++l) {
                    for (int w = 0; w < structureWidth; ++w) {
                        BlockPos pos = new BlockPos(l, h, w);
                        BlockState state = this.structureWorld.m_8055_(pos);
                        if (state.m_60795_()) continue;
                        transform.m_85836_();
                        transform.m_85837_((double)l, (double)h, (double)w);
                        int overlay = pos.equals((Object)new BlockPos(1, 1, 1)) ? OverlayTexture.m_118090_((float)0.0f, (boolean)true) : OverlayTexture.f_118083_;
                        ModelData modelData = ModelData.EMPTY;
                        BlockEntity te = this.structureWorld.m_7702_(pos);
                        if (te != null) {
                            modelData = te.getModelData();
                        }
                        BakedModel model = blockRender.m_110910_(state);
                        for (RenderType renderType : model.getRenderTypes(state, this.structureWorld.f_46441_, modelData)) {
                            blockRender.m_110937_().tesselateBlock((BlockAndTintGetter)this.structureWorld, blockRender.m_110910_(state), state, pos, transform, buffer.m_6299_(MantleRenderTypes.TRANSLUCENT_FULLBRIGHT), false, this.structureWorld.f_46441_, state.m_60726_(pos), overlay, modelData, renderType);
                        }
                        transform.m_85849_();
                    }
                }
            }
            transform.m_85849_();
            transform.m_85849_();
        }
        catch (Exception e) {
            long now = System.currentTimeMillis();
            if (now > this.lastPrintedErrorTimeMs + 1000L) {
                e.printStackTrace();
                this.lastPrintedErrorTimeMs = now;
            }
            while (lastEntryBeforeTry != transform.m_85850_()) {
                transform.m_85849_();
            }
        }
        buffer.m_109911_();
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void mouseDragged(double clickX, double clickY, double mouseX, double mouseY, double lastX, double lastY, int button) {
        double dx = mouseX - lastX;
        double dy = mouseY - lastY;
        this.additionalTransform = this.forRotation(dx * 80.0 / 104.0, dy * 0.8).m_121096_(this.additionalTransform);
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY, int clickedMouseButton) {
        super.mouseReleased(mouseX, mouseY, clickedMouseButton);
    }

    private Transformation forRotation(double rX, double rY) {
        Vector3f axis = new Vector3f((float)rY, (float)rX, 0.0f);
        float angle = (float)Math.sqrt(axis.m_122276_(axis));
        if (!axis.m_122278_()) {
            return Transformation.m_121093_();
        }
        return new Transformation(null, new Quaternion(axis, angle, true), null, null);
    }
}

