/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.repository;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.repository.BookRepository;

public class FileRepository
extends BookRepository {
    public final ResourceLocation location;

    public FileRepository(ResourceLocation location) {
        this.location = location;
    }

    @Override
    public List<SectionData> getSections() {
        return new ArrayList<SectionData>(Arrays.asList((SectionData[])BookLoader.getGson().fromJson(this.resourceToString(this.getResource(this.getResourceLocation("index.json"))), SectionData[].class)));
    }

    @Override
    public ResourceLocation getResourceLocation(@Nullable String path, boolean safe) {
        if (path == null) {
            return safe ? new ResourceLocation("") : null;
        }
        if (!path.contains(":")) {
            ResourceLocation res;
            String langPath = null;
            if (Minecraft.m_91087_().m_91102_() != null && Minecraft.m_91087_().m_91102_().m_118983_() != null) {
                langPath = Minecraft.m_91087_().m_91102_().m_118983_().getCode();
            }
            String defaultLangPath = "en_us";
            if (langPath != null && this.resourceExists(res = new ResourceLocation(this.location + "/" + langPath + "/" + path))) {
                return res;
            }
            res = new ResourceLocation(this.location + "/" + defaultLangPath + "/" + path);
            if (this.resourceExists(res)) {
                return res;
            }
            res = new ResourceLocation(this.location + "/" + path);
            if (this.resourceExists(res)) {
                return res;
            }
        } else {
            ResourceLocation res = new ResourceLocation(path);
            if (this.resourceExists(res)) {
                return res;
            }
        }
        return safe ? new ResourceLocation("") : null;
    }

    @Override
    public Optional<Resource> getLocation(@Nullable ResourceLocation loc) {
        if (loc == null) {
            return Optional.empty();
        }
        return Minecraft.m_91087_().m_91098_().m_213713_(loc);
    }

    @Override
    public String resourceToString(@Nullable Resource resource, boolean skipComments) {
        if (resource == null) {
            return "";
        }
        try {
            Iterator iterator = IOUtils.readLines((InputStream)resource.m_215507_(), (Charset)StandardCharsets.UTF_8).iterator();
            StringBuilder builder = new StringBuilder();
            boolean isLongComment = false;
            while (iterator.hasNext()) {
                String s = ((String)iterator.next()).trim() + "\n";
                if (skipComments) {
                    if (isLongComment) {
                        if (!s.endsWith("*/")) continue;
                        isLongComment = false;
                        continue;
                    }
                    if (s.startsWith("/*")) {
                        isLongComment = true;
                        continue;
                    }
                    if (s.startsWith("//")) continue;
                }
                builder.append(s);
            }
            return builder.toString().trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

